<?php
namespace boru\dhfw\util\query;

use boru\dhfw\util\QueryBuilder;

class Condition {
    private $fieldType;
    private $fieldName;
    private $comparator;
    private $value;

    private $sqlData = [];

    public function __construct($fieldType,$fieldName,$comparator,$value) {
        $this->fieldType = $fieldType;
        $this->fieldName = $fieldName;
        $this->comparator = $comparator;
        $this->value = $value;
        $this->sqlData = QueryBuilder::makeForSql($fieldType,$fieldName,$comparator,$value);
    }


    public function toSql() {
        return $this->sqlData["sql"];
    }
    public function getValues() {
        return $this->sqlData["value"];
    }
}