<?php
require __DIR__."/../vendor/autoload.php";

use boru\dhprocess\Task;
use boru\dhprocess\TaskQueue;
use React\Promise\Deferred;

TaskQueue::init([
    "numWorkers"=>5,
    "maxQueued"=>100,
    "extendedBar"=>true,
    "bootstrapFile"=>__DIR__."/HelperClass.php",
    "done"=>true,
]);

//The function that will run on the generated output from the generator function
Task::register("run",function($id=0,$minRand=0.5,$maxRand=3) {
    $minMicro = $minRand*1000000;
    $maxMicro = $maxRand*1000000;
    $rand = rand($minMicro,$maxMicro);
    $seconds = round($rand / 1000000,2);
    usleep($rand);
    $result = [];
    $result["id"] = $id;
    $result["sleep"] = $seconds;
    return $result;
});

//This is just a function that will yield a promise that will resolve after a random time between 1 and 5 seconds
//This similates an async running generator function
$task = TaskQueue::task(function() {
    for($i=0;$i<20;$i++) {
        $deferred = new Deferred();
        $rand = rand(1,5);
        $seconds = $rand;
        \React\Promise\Timer\sleep($seconds)->then(function() use($seconds,$deferred,$i) {
            $deferred->resolve(["run"=>$i,"when"=>time(),"delay"=>$seconds]);
        });
        yield $deferred->promise();
    }
    return ["run"=>0,"message"=>"runComplete"];
});
$task->name("generator");
$task->description("generator task");
//This defines the action to take on the generated output from the generator function.. here is where we tell it to run the 'run' task defined above
$task->generate(function($result,$work) {
    $runNumber= $result["run"];
    $id = $runNumber;
    TaskQueue::Task("run",[$id,1,2])->name("subtask")->description("task ".$id);
});

TaskQueue::wait();
