<?php
//Always use an external file that includes the project dependencies, or manually set a bootstrap file in the Threader class options.
require __DIR__."/init.php";

use boru\dhprocess\TaskQueue;
use boru\dhprocess\Threader;


//Items can be anything that implements 'iterable' (array, generator, etc)
//populate an array with 100 items
$items = [];
for($i=0;$i<5;$i++) {
    $items[] = $i;
}

//Threader::setRateLimit(1,1);

//Static simple method
$threader = Threader::execute($items,function($item) {
    $startTime = microtime(true);
    $minRand = 0.2;
    $maxRand = 1;
    $minMicro = $minRand*1000000;
    $maxMicro = $maxRand*1000000;
    $rand = rand($minMicro,$maxMicro);
    //$seconds = round($rand / 1000000,2);
    usleep($rand);
    //throw new Exception("Error");
    return ["item"=>$item,"started"=>$startTime,"ended"=>microtime(true)];
});
print_r($threader->results());


//set some options
Threader::option("numWorkers",2);
