<?php
namespace boru\dhprocess\config;

use boru\dhutils\dhGlobal;

class QueueConfig extends BaseConfig {
    protected $data = [
        "numWorkers"=>3,
        "maxQueued"=>0,
        "visualize"=>true,
        "log"=>false,
        "extendedBar"=>false,
        
        "threadStatusInterval"=>60,
        "maxIdleTime"=>300,
        "idleUpdateInterval"=>10,

        "threadTemplate"=>null,
        "summaryTemplate"=>null,
        "idleUpdateTemplate"=>null,
    ];

    /**
     * Set or Get the value of numWorkers
     * @param mixed $numWorkers 
     * @param mixed $default 
     * @return mixed 
     */
    public function numWorkers($numWorkers=null,$default=null) {
        if(is_null($numWorkers)) return $this->get("numWorkers",$default);
        $this->set("numWorkers",$numWorkers);
        return $this;
    }
    /**
     * Set or Get the value of maxQueued
     * @param mixed $maxQueued 
     * @param mixed $default 
     * @return mixed 
     */
    public function maxQueued($maxQueued=null,$default=null) {
        if(is_null($maxQueued)) return $this->get("maxQueued",$default);
        $this->set("maxQueued",$maxQueued);
        return $this;
    }
    /**
     * Set or Get the value of visualize
     * @param mixed $visualize 
     * @param mixed $default 
     * @return mixed 
     */
    public function visualize($visualize=null,$default=null) {
        if(is_null($visualize)) return $this->get("visualize",$default);
        $this->set("visualize",$visualize);
        return $this;
    }
    /**
     * Set or Get the value of extendedBar
     * @param mixed $extendedBar 
     * @param mixed $default 
     * @return mixed 
     */
    public function extendedBar($extendedBar=null,$default=null) {
        if(is_null($extendedBar)) return $this->get("extendedBar",$default);
        $this->set("extendedBar",$extendedBar);
        return $this;
    }
    /**
     * Set or Get the value of log
     * @param mixed $log 
     * @param mixed $default 
     * @return self|mixed 
     */
    public function log($log=null,$default=null) {
        if(is_null($log)) return $this->get("log",$default);
        $this->set("log",$log);
        return $this;
    }
    /**
     * Set or Get the value of threadStatusInterval
     * @param mixed $threadStatusInterval 
     * @param mixed $default 
     * @return self|int|false 
     */
    public function threadStatusInterval($threadStatusInterval=null,$default=null) {
        if(is_null($threadStatusInterval)) return $this->get("threadStatusInterval",$default);
        $this->set("threadStatusInterval",$threadStatusInterval);
        return $this;
    }
    /**
     * Set or Get the value of maxIdleTime
     * @param mixed $maxIdleTime 
     * @param mixed $default 
     * @return self|int|false 
     */
    public function maxIdleTime($maxIdleTime=null,$default=null) {
        if(is_null($maxIdleTime)) return $this->get("maxIdleTime",$default);
        $this->set("maxIdleTime",$maxIdleTime);
        return $this;
    }
    /**
     * Set or Get the value of idleUpdateInterval
     * @param mixed $idleUpdateInterval 
     * @param mixed $default 
     * @return self|int|false
     */
    public function idleUpdateInterval($idleUpdateInterval=null,$default=null) {
        if(is_null($idleUpdateInterval)) return $this->get("idleUpdateInterval",$default);
        $this->set("idleUpdateInterval",$idleUpdateInterval);
        return $this;
    }
    
    /**
     * Set or Get the value of threadTemplate
     * @param mixed $threadTemplate 
     * @param mixed $default 
     * @return self|string|false 
     */
    public function threadTemplate($threadTemplate=null,$default=null) {
        if(is_null($threadTemplate)) return $this->get("threadTemplate",$default);
        $this->set("threadTemplate",$threadTemplate);
        return $this;
    }
    /**
     * Set or Get the value of summaryTemplate
     * @param mixed $summaryTemplate 
     * @param mixed $default 
     * @return self|string|false 
     */
    public function summaryTemplate($summaryTemplate=null,$default=null) {
        if(is_null($summaryTemplate)) return $this->get("summaryTemplate",$default);
        $this->set("summaryTemplate",$summaryTemplate);
        return $this;
    }
    /**
     * Set or Get the value of idleUpdateTemplate
     * @param mixed $idleUpdateTemplate 
     * @param mixed $default 
     * @return self|string|false 
     */
    public function idleUpdateTemplate($idleUpdateTemplate=null,$default=null) {
        if(is_null($idleUpdateTemplate)) return $this->get("idleUpdateTemplate",$default);
        $this->set("idleUpdateTemplate",$idleUpdateTemplate);
        return $this;
    }
}