<?php
namespace boru\dhprocess\traits;

use boru\dhprocess\message\ExceptionResult;
use boru\dhprocess\message\Result;
use boru\dhprocess\TaskQueue;
use boru\dhprocess\work\Work;

trait TaskCallbacks {
    private function addCallback(&$callbackCollection,$callback=null) {
        if(is_null($callback)) {
            return;
        }
        $callbackCollection[] = $callback;
    }

    public function callbacks($onStart=null,$onQueue=null,$onDone=null,$onError=null,$onFinal=null,$onGenerator=null) {
        $this->addCallback($this->onStartCallback,$onStart);
        $this->addCallback($this->onQueueCallback,$onQueue);
        $this->addCallback($this->onDoneCallback,$onDone);
        $this->addCallback($this->onErrorCallback,$onError);
        $this->addCallback($this->onFinalCallback,$onFinal);
        $this->addCallback($this->onGeneratorCallback,$onGenerator);
        return $this;
    }
    public function then($onDone=null,$onError=null) {
        $this->addCallback($this->onDoneCallback,$onDone);
        $this->addCallback($this->onErrorCallback,$onError);
        return $this;
    }
    public function lastly($onFinal=null) {
        $this->addCallback($this->onFinalCallback,$onFinal);
    }
    public function onStart($onStart=null) {
        $this->addCallback($this->onStartCallback,$onStart);
        return $this;
    }
    public function onQueue($onQueue=null) {
        $this->addCallback($this->onQueueCallback,$onQueue);
        return $this;
    }
    public function onDone($onDone=null) {
        $this->addCallback($this->onDoneCallback,$onDone);
        return $this;
    }
    public function onError($onError=null) {
        $this->addCallback($this->onErrorCallback,$onError);
        return $this;
    }
    public function onGenerator($onGenerator=null) {
        if(!is_null($onGenerator)) {
            $this->work->isGenerator(true);
        }
        $this->addCallback($this->onGeneratorCallback,$onGenerator);
        return $this;
    }
    public function generate($generator=null) {
        if(!is_null($generator)) {
            $this->work->isGenerator(true);
        }
        $this->addCallback($this->onGeneratorCallback,$generator);
        return $this;
    }

    private function callbackOnDone($result) {
        if(is_object($result) && $result instanceof Result) {
            $this->result = $result;
            $this->data = $result->result();
            $this->error = $result->error();
        } else {
            $this->data = $result;
        }
        $this->runCallbacks($this->onDoneCallback,$this->data,$this);
        if($this->showDone) {
            if(!$this->showDetailed) {
                static::display("done",$this->displayName());
            } else {
                static::display("done",$this->displayName(),":",$this->data);
            }
        }
        $this->runCallbacks($this->onFinalCallback,$this->data,$this);
        $this->cleanupWork();
    }
    private function callbackOnError($result) {
        if(is_object($result)) {
            if($result instanceof ExceptionResult || $result instanceof \Exception) {
                $this->error = $result;
            } elseif($result instanceof Result) {
                $this->result = $result;
                $this->data = $result->result();
                $this->error = $result->error();
            } elseif(method_exists($result,"getMessage")) {
                $this->error = $result->getMessage();
            }
        } else {
            $this->error = $result;
        }

        if(!TaskQueue::get("errorExceptions",false) && $this->error instanceof \Exception) {
            $this->error = $this->error->getMessage();
        }
        
        if(!empty($this->onErrorCallback)) {
            $this->runCallbacks($this->onErrorCallback,$this->error,$this);
        } elseif(!empty($this->onDoneCallback)) {
            $this->runCallbacks($this->onDoneCallback,null,$this);
        }
        if($this->showDone) {
            if(!$this->showDetailed) {
                static::display("error",$this->displayName());
            } else {
                static::display("error",$this->displayName(),":",$this->error);
            }
        }
        $this->cleanupWork();
    }
    private function callbackOnStart() {
        if($this->showStart) {
            static::display("start",$this->displayName());
        }
        $this->runCallbacks($this->onStartCallback,$this);
    }
    private function callbackOnQueue() {
        if($this->showQueued) {
            static::display("queued",$this->displayName());
        }
        $this->runCallbacks($this->onQueueCallback,$this);
    }
    private function callbackOnGenerator($result) {
        if(is_object($result) && $result instanceof Result) {
            $data = $result->result();
            $error = $result->error();
        } else {
            $data = $result;
        }
        $this->runCallbacks($this->onGeneratorCallback,$data,$this);
    }
    private function runCallbacks($callback,...$args) {
        if(is_null($callback) || empty($callback)) {
            return;
        }
        if(is_array($callback)) {
            foreach($callback as $cb) {
                $cb(...$args);
            }
        } else {
            $callback(...$args);
        }
    }
    public function cleanupWork($force=false) {
        if(property_exists($this,"cleanupOnDone") && !is_null($this->cleanupOnDone) && $this->cleanupOnDone) {
            if(!is_null($this->work) && $this->work instanceof Work) {
                $this->work->destroy();
            }
            $this->result = $this->error = $this->data = null;
        }
    }
}