<?php
require __DIR__."/../vendor/autoload.php";

use boru\dhprocess\Task;
use boru\dhprocess\TaskQueue;


TaskQueue::init([
    "numWorkers"=>5,
    "maxQueued"=>100,
    "extendedBar"=>true,
    "bootstrapFile"=>__DIR__."/HelperClass.php",
    "done"=>true,
    /*"logLevels" => [
        "debug" => false,
        "info" => true,
        "warning" => true,
        "error" => true,
        "comms" => true,
    ],
    "logPrint"=>false,
    "logDir"=>__DIR__."/_logs",*/
]);
TaskQueue::setRateLimit("a",1,5);
TaskQueue::setRateLimit("b",1,5);

//The function that will the work
Task::register("run",function($id=0,$minRand=0.5,$maxRand=3) {
    $minMicro = $minRand*1000000;
    $maxMicro = $maxRand*1000000;
    $rand = rand($minMicro,$maxMicro);
    $seconds = round($rand / 1000000,2);
    usleep($rand);
    $result = [];
    $result["id"] = $id;
    $result["sleep"] = $seconds;
    return $result;
});

for($i=0;$i<3;$i++) {
    //if odd, use rate limit "a", if even, use rate limit "b"
    $rateLimitKey = ($i%2==0) ? "a" : "b";
    TaskQueue::task("run",[$i,0.1,0.2])->name("testRun".$i)->rateLimitKey($rateLimitKey);
}
TaskQueue::wait();