<?php
require __DIR__."/../vendor/autoload.php";

use boru\dhprocess\Task;
use boru\dhprocess\TaskQueue;


TaskQueue::init([
    "numWorkers"=>5,
    "maxQueued"=>100,
    "extendedBar"=>true,
    "bootstrapFile"=>__DIR__."/HelperClass.php",
    "done"=>true,
]);

//register requires a name and a callable
Task::register("run",["HelperClass","run"]);

//simple loop for demo purposes
for($i=0;$i<1000;$i++) {
    //task to run.. first parameter is the name used in the 'register' above, and second parameter is an array of parameters that the Callable requires.
    //showStart, showDone, showDetailed, and 'short' are all just for display purposes and completely optional.. the process will run without them.
    TaskQueue::task("run",[$i,1,3])->name("testRun".$i);
}

TaskQueue::wait();