<?php
namespace boru\dhprocess;

use boru\dhprocess\Task;
use boru\dhprocess\TaskQueue;
use boru\dhutils\dhGlobal;

class Threader {
    private static $taskQueueOptions = [
        "numWorkers"=>5,
        "maxQueued"=>100,
        "extendedBar"=>true,
        "bootstrapFile"=>null,
        "done"=>true,
    ];
    private static $_thread_is_init = false;

    public static function _init_thread() {
        if(self::$_thread_is_init === false) {
            self::$_thread_is_init = true;
            self::init();
        }
    }
    public static function init($options=[]) {
        $queueOptions = array_merge(self::$taskQueueOptions,$options);
        if($queueOptions["bootstrapFile"] === null) {
            $queueOptions["bootstrapFile"] = self::bootstrapFile();
        }
        TaskQueue::init($queueOptions);
    }
    public static function option($option,$value=null) {
        if($value === null) {
            return self::$taskQueueOptions[$option];
        }
        self::$taskQueueOptions[$option] = $value;
    }
    public static function bootstrapFile($fileName=null) {
        if($fileName !== null) {
            self::option("bootstrapFile",$fileName);
        }
        if(static::option("bootstrapFile") === null) {
            $autoloadIncludedIn = dhGlobal::findAutoloadIncludedBy();
            self::option("bootstrapFile",$autoloadIncludedIn);
        };
    }

    public static function setRateLimit($limit,$timeInSeconds) {
        TaskQueue::setRateLimit("Threader",$limit,$timeInSeconds);
    }

    private $id;
    private $callback;
    private $items = [];
    private $collect = [];
    public function __construct($items=[],$callback=null,$options=null) {
        $this->id = uniqid();
        if($options === null) {
            static::_init_thread();
        }else {
            self::init($options);
        }
        if($callback !== null) {
            $this->callback = $callback;
        }
        if($items !== null) {
            if(!is_array($items)) {
                $aitems = json_decode($items,true);
                if(!is_array($aitems)) {
                    $items = [$items];
                } else {
                    $items = $aitems;
                }
            }
            $this->items = $items;
        }
    }

    public function callback($callback=null) {
        if($callback !== null) {
            $this->callback = $callback;
        }
        return $this->callback;
    }
    public function add($item) {
        $this->items[] = $item;
    }
    public function collect($collect=null) {
        if($collect !== null) {
            $this->collect = $collect;
        }
        return $this->collect;
    }
    public function run($collect=false) {
        Task::register($this->id,$this->callback());
        TaskQueue::expected(count($this->items));
        foreach($this->items as $item) {
            if(!is_array($item)) {
                $item = [$item];
            }
            $task = TaskQueue::task($this->id,$item)->rateLimitKey("Threader");
            $task->onError(function($error,$task) {
                if($error instanceof \Exception || (is_object($error) && method_exists($error,"getMessage"))) {
                    $error = $error->getMessage();
                } elseif(is_object($error) || is_array($error)) {
                    $error = json_encode($error);
                }
                $task->description($error);
            });
            if($collect === true) {
                $task->onDone(function($result,$task) {
                    $this->collect[] = $result;
                });
            }
        }
        TaskQueue::wait();
        if($collect === true) {
            return $this->collect;
        }
        return true;
    }

    public function id() {
        return $this->id;
    }
    public function items() {
        return $this->items;
    }
    public function results() {
        return $this->collect;
    }

    public static function process($items,$callback=null,$options=null) {
        return self::execute($items,$callback,$options);
    }

    /**
     * Executes a threader
     * @param array|string $items
     * @param callable $callback optional
     * @param array $options optional
     * @return mixed
     */
    public static function execute($items,$callback=null,$options=null) {
        $threader = new Threader($items,$callback,$options);
        $threader->run(true);
        return $threader;
    }
}