<?php
namespace boru\dhprocess\config;

use boru\dhutils\dhGlobal;

class BaseConfig {
    protected $data = [
    ];

    /**
     * Pre-configure the object with an array of $options
     * @param array $options 
     * @return void 
     */
    public function __construct($options=[]) {
        $this->config($options);
    }

    /**
     * Configure the object with an array of $options
     * @param array $options 
     * @return $this 
     */
    public function config($options=[]) {
        foreach($options as $k=>$v) {
            $this->set($k,$v);
        }
        return $this;
    }
    /**
     * Get the value for $key. if $key is null, the whole array is returned.
     * @param null|mixed $key if null, returns the entire array. Otherwise, a dot-separated key to find in the configuration array
     * @param mixed $default default return value if $key isn't found/set
     * @return mixed 
     */
    public function get($key=null,$default=null) {
        if(is_null($key)) {
            return $this->data;
        }
        return dhGlobal::getVal($this->data,$key,$default);
    }
    /**
     * Set the value of $key
     * @param mixed $key 
     * @param mixed $value 
     * @return $this 
     */
    public function set($key,$value=null) {
        dhGlobal::dotAssign($this->data,$key,$value);
        return $this;
    }
}