<?php
namespace boru\dhprocess\process\traits;

use boru\dhutils\dhGlobal;
use React\Promise\Deferred;

trait GettersSetters {
    public function id() {
        return $this->getId();
    }
    public function getId() {
        return $this->getPid();
    }
    /**
     * Get the value of pid
     * @return  mixed
     */
    public function getPid() {
        return $this->pid;
    }
    public function isDone() {
        return $this->done;
    }
    public function isRunning() {
        return $this->running;
    }
    public function isReady() {
        return $this->ready;
    }
    /**
     * Get the value of command
     * @return  mixed
     */
    public function getCommand() {
        return $this->command;
    }
    /**
     * Get the value of args
     * @return  mixed
     */
    public function getArgs() {
        return $this->args;
    }
    /**
     * Get the value of meta
     * @return  mixed
     */
    public function getMeta() {
        return $this->meta;
    }
    /**
     * Return the processes's stdOut stream interface
     * @return \React\Stream\ReadableStreamInterface
     */
    public function stdOut() {
        return $this->process->stdout;
    }
    /**
     * Return the processes's stdErr stream interface
     * @return \React\Stream\ReadableStreamInterface
     */
    public function stdErr() {
        return $this->process->stderr;
    }
    /**
     * Return the processes's stdIn stream interface
     * @return \React\Stream\WritableStreamInterface
     */
    public function stdIn() {
        return $this->process->stdin;
    }

    /**
     * Return the Deferred
     * @return Deferred 
     */
    public function Deferred() {
        return $this->deferred;
    }

    /**
     * Return the Promise (if exists)
     * @return Promise|false 
     */
    public function Promise() {
        return !is_null($this->deferred) ? $this->deferred->promise() : false;
    }

    public function setMetaData($key,$val="",$append=false) {
        if(strpos($key,".") !== false) {
            if($append) {
                $check = dhGlobal::getDot($this->metaData,$key);
                if(!is_null($check)) {
                    if(is_array($check)) {
                        $check[] = $val;
                        $val = $check;
                    } else {
                        $narr = [];
                        $narr[] = $check;
                        $narr[] = $val;
                        $val = $narr;
                    }
                }
            }
            dhGlobal::dotAssign($this->metaData,$key,$val);
        }
        else {
            if(isset($this->metaData[$key]) && $append) {
                if(is_array($this->metaData[$key])) {
                    $this->metaData[$key][] = $val;
                } else {
                    $temp = $this->metaData[$key];
                    $array[$key] = [];
                    $array[$key][] = $temp;
                    $array[$key][] = $val;
                }
            } else {
                $this->metaData[$key] = $val;
            }
        }
        return $this;
    }
    public function getMetaData($key=null,$default=null,$exists=false) {
        if(is_null($key)) {
            if($exists) {
                return !empty($this->metaData) ? true : false;
            } else {
                return !empty($this->metaData) ? $this->metaData : $default;
            }
        }
        if(strpos($key,".") !== false) {
            $uniqueid = uniqid("getArray",true);
            if(($check = dhGlobal::getDot($this->metaData,$key,$uniqueid)) !== $uniqueid) {
                return $exists ? true : $check;
            };
        }
        if($exists) {
            return isset($this->metaData[$key]);
        } else {
            return isset($this->metaData[$key]) ? $this->metaData[$key] : $default;
        }
        
    }
    public function metaDataExists($key) {
        return $this->getMetaData($key,null,true);
    }

    /**
     * Set the value of running
     * @param   bool  $running  
     * @return  self
     */
    public function setRunning($running) {
        $this->running = $running;
        return $this;
    }

    /**
     * Set the value of done
     * @param   bool  $done  
     * @return  self
     */
    public function setDone($done) {
        $this->done = $done;
        return $this;
    }

    /**
     * Set the Deferred that will be resolved on completion
     * @param Deferred $deferred 
     * @return $this 
     */
    public function setDeferred(Deferred $deferred) {
        $this->deferred = $deferred;
        return $this;
    }


    /**
     * Set the value of pid
     * @param   mixed  $pid  
     * @return  self
     */
    public function setPid($pid) {
        $this->pid = $pid;
        return $this;
    }
    /**
     * Set the value of command
     * @param   mixed  $command  
     * @return  self
     */
    public function setCommand($command) {
        $this->command = $command;
        return $this;
    }
    /**
     * Set the value of args
     * @param   mixed  $args  
     * @return  self
     */
    public function setArgs($args) {
        $this->args = $args;
        return $this;
    }
}