<?php
namespace boru\dhprocess\traits;

use boru\dhutils\dhGlobal;
use boru\dhutils\tools\StdOut;

trait TaskDisplay {
    public static $queueVerbs = ["queue","queued","pending","waiting","wait"];
    public static $startVerbs =["start","init"];
    public static $doneVerbs = ["done","finished","complete","completed","success"];
    public static $errorVerbs = ["error","fail","failed","failure"];

    public static $queuePrefix = ">      queued  :";
    public static $startPrefix = "> ---   start  :";
    public static $donePrefix  = "> ***   done   :";
    public static $errorPrefix = "> !!!   error  :";

    public static function display($action,$identifier,...$args) {
        $displayLen = stdOut::getCols(60);
        if($displayLen<20) {
            $displayLen=20;
        }
        $prefix = "";
        if(in_array($action,static::$doneVerbs)) {
            $prefix = static::$donePrefix;
        } elseif(in_array($action,static::$startVerbs)) {
            $prefix = static::$startPrefix;
        } elseif(in_array($action,static::$queueVerbs)) {
            $prefix = static::$queuePrefix;
        } elseif(in_array($action,static::$errorVerbs)) {
            $prefix = static::$errorPrefix;
        }
        $argString = "";
        if(!empty($args)) {
            foreach($args as $k=>$arg) {
                $args[$k] = StdOut::argToString($arg,true);
            }
            $argString = implode(" ",$args);
            if(strlen($argString) >= $displayLen) {
                $argString=substr($argString,0,$displayLen-4)." ...";
            }
        }
        dhGlobal::outLine($prefix,$identifier,$argString);
    }

    public static function addStartVerb($verb) {
        static::$startVerbs[] = $verb;
    }
    public static function addQueueVerb($verb) {
        static::$queueVerbs[] = $verb;
    }
    public static function addDoneVerb($verb) {
        static::$doneVerbs[] = $verb;
    }
    public static function addErrorVerb($verb) {
        static::$errorVerbs[] = $verb;
    }
    public static function setStartPrefix($prefix) {
        static::$startPrefix = $prefix;
    }
    public static function setQueuePrefix($prefix) {
        static::$queuePrefix = $prefix;
    }
    public static function setDonePrefix($prefix) {
        static::$donePrefix = $prefix;
    }
    public static function setErrorPrefix($prefix) {
        static::$errorPrefix = $prefix;
    }
    public static function setQueueVerbs($verbs) {
        static::$queueVerbs = $verbs;
    }
    public static function setStartVerbs($verbs) {
        static::$startVerbs = $verbs;
    }
    public static function setDoneVerbs($verbs) {
        static::$doneVerbs = $verbs;
    }
    public static function setErrorVerbs($verbs) {
        static::$errorVerbs = $verbs;
    }
}