<?php
namespace boru\dhprocess\traits;

trait TaskGettersSetters {
    public function onDoneCallback($onDoneCallback=null) {
        return is_null($onDoneCallback) ? $this->getOnDoneCallback() : $this->setOnDoneCallback($onDoneCallback);
    }
    public function onErrorCallback($onErrorCallback=null) {
        return is_null($onErrorCallback) ? $this->getOnErrorCallback() : $this->setOnErrorCallback($onErrorCallback);
    }
    public function onStartCallback($onStartCallback=null) {
        return is_null($onStartCallback) ? $this->getOnStartCallback() : $this->setOnStartCallback($onStartCallback);
    }
    public function onQueueCallback($onQueueCallback=null) {
        return is_null($onQueueCallback) ? $this->getOnQueueCallback() : $this->setOnQueueCallback($onQueueCallback);
    }
    public function onGeneratorCallback($onGeneratorCallback=null) {
        return is_null($onGeneratorCallback) ? $this->getOnGeneratorCallback() : $this->setOnGeneratorCallback($onGeneratorCallback);
    }
    /**
     * @param mixed $showDone 
     * @return bool|self 
     */
    public function showDone($showDone=null) {
        return is_null($showDone) ? $this->getShowDone() : $this->setShowDone($showDone);
    }
    /**
     * @param mixed $showDone 
     * @return bool|self 
     */
    public function showStart($showStart=null) {
        return is_null($showStart) ? $this->getShowStart() : $this->setShowStart($showStart);
    }
    /**
     * @param mixed $showDone 
     * @return bool|self 
     */
    public function showQueued($showQueued=null) {
        return is_null($showQueued) ? $this->getShowQueued() : $this->setShowQueued($showQueued);
    }
    /**
     * @param mixed $showDone 
     * @return bool|self 
     */
    public function showDetailed($showDetailed=null) {
        return is_null($showDetailed) ? $this->getShowDetailed() : $this->setShowDetailed($showDetailed);
    }

    public function setVerbosity($start=false,$queue=false,$done=false,$detail=false) {
        $this->showStart($start);
        $this->showQueued($queue);
        $this->showDone($done);
        $this->showDetailed($detail);
    }
    /**
	 * Get the value of onDoneCallback
     * @return  mixed
     */
    public function getOnDoneCallback() {
        return $this->onDoneCallback;
    }

    /**
     * Set the value of onDoneCallback
     * @param   mixed  $onDoneCallback  
     * @return  self
	 */
    public function setOnDoneCallback($onDoneCallback) {
        $this->onDoneCallback = $onDoneCallback;
        return $this;
    }

    /**
	 * Get the value of onErrorCallback
     * @return  mixed
     */
    public function getOnErrorCallback() {
        return $this->onErrorCallback;
    }

    /**
     * Set the value of onErrorCallback
     * @param   mixed  $onErrorCallback  
     * @return  self
	 */
    public function setOnErrorCallback($onErrorCallback) {
        $this->onErrorCallback = $onErrorCallback;
        return $this;
    }

    /**
	 * Get the value of onStartCallback
     * @return  mixed
     */
    public function getOnStartCallback() {
        return $this->onStartCallback;
    }

    /**
     * Set the value of onStartCallback
     * @param   mixed  $onStartCallback  
     * @return  self
	 */
    public function setOnStartCallback($onStartCallback) {
        $this->onStartCallback = $onStartCallback;
        return $this;
    }

    /**
	 * Get the value of onQueueCallback
     * @return  mixed
     */
    public function getOnQueueCallback() {
        return $this->onQueueCallback;
    }

    /**
     * Set the value of onQueueCallback
     * @param   mixed  $onQueueCallback  
     * @return  self
	 */
    public function setOnQueueCallback($onQueueCallback) {
        $this->onQueueCallback = $onQueueCallback;
        return $this;
    }

    /**
	 * Get the value of showDone
     * @return  mixed
     */
    public function getShowDone() {
        return $this->showDone;
    }

    /**
     * Set the value of showDone
     * @param   mixed  $showDone  
     * @return  self
	 */
    public function setShowDone($showDone) {
        $this->showDone = $showDone;
        return $this;
    }

    /**
	 * Get the value of showStart
     * @return  mixed
     */
    public function getShowStart() {
        return $this->showStart;
    }

    /**
     * Set the value of showStart
     * @param   mixed  $showStart  
     * @return  self
	 */
    public function setShowStart($showStart) {
        $this->showStart = $showStart;
        return $this;
    }

    /**
	 * Get the value of showQueued
     * @return  mixed
     */
    public function getShowQueued() {
        return $this->showQueued;
    }

    /**
     * Set the value of showQueued
     * @param   mixed  $showQueued  
     * @return  self
	 */
    public function setShowQueued($showQueued) {
        $this->showQueued = $showQueued;
        return $this;
    }

    /**
	 * Get the value of showDetailed
     * @return  mixed
     */
    public function getShowDetailed() {
        return $this->showDetailed;
    }

    /**
     * Set the value of showDetailed
     * @param   mixed  $showDetailed  
     * @return  self
	 */
    public function setShowDetailed($showDetailed) {
        $this->showDetailed = $showDetailed;
        return $this;
    }
}