<?php
namespace boru\dhprocess\worker;

use boru\dhutils\async\Message;
use boru\dhutils\dhGlobal;

class WorkerUtils {
    public static $bootstrap;

    public static function testError(...$args) {
        $rand = 'rand'; //vscode intellisense fix
        usleep($$rand(0,3)*1000000); //sleep 0-3 seconds
        if(!empty($args)) {
            $message = isset($args[0]) ? $args[0] : "Testing a forced Exception error";
            $code = isset($args[1]) ? $args[1] : 0;
        } else {
            $message = "Testing a forced Exception error";
            $code = 0;
        }
        if($$rand(0,50)>48) {
            throw new \Exception($message,$code);
        }
        
    }
    public static function exec(...$args) {
        if(!empty($args) && !is_null($args)) {
            $command = implode(" ",$args);
            passthru($command);
            return ["status"=>true,"command"=>$command];
        }
        throw new \Exception("static::exec requires at least 1 arg");
        return ["status"=>false];
    }

    public static function http(...$args) {
        $reqData = $args[0];
        $method  = dhGlobal::getVal($reqData,"method",false);
        $url     = dhGlobal::getVal($reqData,"url",false);
        $getJson = dhGlobal::getVal($reqData,"getJson",false);
        if($method === false || $url === false) {
            throw new \Exception("static::http requires 1 arg, that arg should be an array ['method'=>'get|post|..','url'=>'requestUrl','options'=>[]");
            return false;
        }
        $http = new \boru\dhutils\dhHttp();
        $req = $http->request($method,$url);
        if(($options = dhGlobal::getVal($reqData,"options",false)) !== false) {
            foreach($options as $type=>$option) {
                if(method_exists($req,$type)) {
                    if(!isset($option[1])) {
                        $req->$type($option[0]);
                    } else {
                        $req->$type($option[1],$option[2]);
                    }
                }
            }
        } elseif(($requestData = dhGlobal::getval($reqData,"requestData",false)) !== false) {
            $req->data = $requestData;
        }
        $response = $req->send();
        if($getJson) {
            $body = $response->body(true);
        } else {
            $body = $response->body();
        }
        return [
            "method"=>$method,
            "url"=>$url,
            "code"=>$response->code(),
            "phrase"=>$response->phrase(),
            "headers"=>$response->header(),
            "body"=>$body,
        ];
    }

    public static function bootstrap($bootstrap) {
        if(!is_null(static::$bootstrap)) {
            throw new WorkerException(Message::E_BOOSTRAPPED_ALREADY,"already bootstrapped with ".json_encode(static::$bootstrap));
        }
        $bootstrapFile = false;
        $setupCallable = false;
        $setupCallableArgs = [];
        if(!is_array($bootstrap)) {
            $bootstrapFile = $bootstrap;
        } elseif(isset($bootstrap["file"]) || isset($bootstrap["callable"])) {
            $bootstrapFile = isset($bootstrap["file"]) ? $bootstrap["file"] : false;
            $setupCallable = isset($bootstrap["callable"]) ? $bootstrap["callable"] : false;
            $setupCallableArgs = isset($bootstrap["args"]) ? $bootstrap["args"] : [];
        } else {
            throw new WorkerException(Message::E_BOOTSTRAP_INVALID,"Bootstrap must either be a filename or an array that includes 'file' and/or 'callable'");
        }
        if(!__bootstrap_include($bootstrapFile)) {
            throw new WorkerException(Message::E_BOOTSTRAP_NOT_FOUND,"File not found: ".$bootstrap);
        }
        if(($callableResponse = __bootstrap_call($setupCallable,$setupCallableArgs)) === false) {
            if(is_array($setupCallable)) { $setupCallable = implode("::",$setupCallable); }
            throw new WorkerException(Message::E_BOOTSTRAP_NOT_CALLABLE,"Cannot call ".$setupCallable);
        }
        static::$bootstrap = $bootstrap;
        $output = [];
        if($bootstrapFile !== false) {
            $output["file"]=$bootstrapFile;
        }
        if($callableResponse !== false) {
            if($setupCallable !== false) {
                $output["callable"]=$setupCallable;
            }
            if($setupCallableArgs !== false) {
                $output["args"]=$setupCallableArgs;
            }
            $output["response"] = $callableResponse;
        }
        return ["bootstrap"=>"static::bootstrap"];
    }
}


function __bootstrap_include($file) {
    if($file === false) {
        return true;
    }
    if(!file_exists($file)) {
        return false;
    }
    include $file;
    return true;
}
function __bootstrap_call($callable,$args) {
    if($callable === false) {
        return true;
    }
    if(!is_callable($callable)) {
        return false;
    }
    try {
        $return = call_user_func($callable,...$args);
    } catch (\Exception $e) {
        $return = false;
    }
    return $return;
}