<?php
namespace boru\dhprocess;

use boru\dhprocess\message\Result;
use boru\dhprocess\traits\TaskCallbacks;
use boru\dhprocess\traits\TaskDisplay;
use boru\dhprocess\traits\TaskGettersSetters;
use boru\dhprocess\work\Work;

class Task {
    use TaskGettersSetters;
    use TaskDisplay;
    use TaskCallbacks;
    
    private static $classMap = [];
    private static $timeoutMap = [];

    public static function register($name,$callable,$defaultTimeout=null) {
        static::$classMap[$name] = $callable;
        static::$timeoutMap[$name] = $defaultTimeout;
    }


    /** @var Work */
    private $work;
    private $onDoneCallback=[];
    private $onErrorCallback=[];
    private $onStartCallback=[];
    private $onQueueCallback=[];
    private $onFinalCallback=[];
    private $onGeneratorCallback=[];

    private $showDone=false;
    private $showStart=false;
    private $showQueued=false;
    private $showDetailed=false;

    /** @var Result */
    private $result;
    private $data;
    private $error;

    private $isGenerator = false;

    private $name;
    private $description;
    private $cleanupOnDone = true;

    public function __construct($name,$args=[],$onDoneCallback=null,$onErrorCallback=null) {
        if($name instanceof \Closure) {
            //$wrapper = new SerializableClosure($name);
            //$callable = serialize($wrapper);
            $callable = \Opis\Closure\serialize($name);
            $name = "closure";
        } else {
            $callable = isset(static::$classMap[$name]) ? static::$classMap[$name] : null;
            if($callable instanceof \Closure) {
                //$wrapper = new SerializableClosure($callable);
                //$callable = serialize($wrapper);
                $callable = \Opis\Closure\serialize($callable);
                $name = "closure";
            } elseif(is_string($callable)) {
                $wrapper = unserialize($callable);
                if(!is_object($wrapper)) {
                    throw new \Exception("Invalid callable");
                }
                $callable = $wrapper->getClosure();
                $name = "closure";
            } elseif(is_array($callable) && count($callable) == 2) {
                $class = $callable[0];
                $method = $callable[1];
                if(is_string($class) && is_string($method)) {
                    $callable = [$class,$method];
                }
            }
        }
        
        $this->work = Work::fromCallable($callable,...$args);
        $this->work->then(function($result) {
            $this->callbackOnDone($result);
        },function($result) {
            $this->callbackOnError($result);
        });
        $this->work->onStart(function() {
            $this->callbackOnStart();
        });
        $this->work->onQueued(function() {
            $this->callbackOnQueue();
        });
        $this->work->onGenerator(function($result) {
            $this->callbackOnGenerator($result);
        });
        $this->showStart = TaskQueue::get("start",false);
        $this->showQueued = TaskQueue::get("queue",false);
        $this->showDone = TaskQueue::get("done",false);
        $this->showDetailed = TaskQueue::get("detail",false);
        //$this->isGenerator = $generator;
        
        $this->name($name);
        $this->taskName($name);
        if(isset(static::$timeoutMap[$name]) && !is_null(static::$timeoutMap[$name])) {
            $this->timeout(static::$timeoutMap[$name]);
        }

        if($onDoneCallback !== null) {
            $this->onDone($onDoneCallback);
        }
        if($onErrorCallback !== null) {
            $this->onError($onErrorCallback);
        }
    }
    
    public function id() {
        return $this->work->getId();
    }
    public function Work() {
        return $this->work;
    }
    public function start() {
        $this->work->start();
    }
    public function stop() {
        $this->work->terminate();
    }
    public function rateLimitKey($key=null) {
        $this->work->rateLimitKey($key);
        return $this;
    }
    
    public function name($name=null) {
        if(is_null($name)) return $this->name;
        $this->name = $name;
        if(is_null($this->description)) {
            $this->work->setMetaData("description",$name);
        } else {
            $this->work->setMetaData("description",$name." : ".$this->description());
        }
        return $this;
    }
    public function timeout($timeout=null) {
        if(is_null($timeout)) return $this->work->getMetaData("timeout",null);
        $this->work->setMetaData("timeout",$timeout);
        return $this;
    }
    public function taskName($taskName=null) {
        if(is_null($taskName)) return $this->work->getMetaData("name",null);
        $this->work->setMetaData("name",$taskName);
        return $this;
    }
    public function short($name=null) {
        return $this->taskName($name);
    }
    public function displayName() {
        if(is_null($this->description)) {
            return $this->name();
        }
        return $this->name()." : ".$this->description();
    }
    public function description($description=null) {
        if(is_null($description)) return $this->description;
        $this->description = $description;
        $this->work->setMetaData("description",$this->name()." : ".$description);
        return $this;
    }
    public function setDisplay($description=null) {
        return $this->description($description);
    }
    public function isGenerator($isGenerator=null) {
        if(is_null($isGenerator)) return $this->isGenerator;
        $this->isGenerator = $isGenerator;
        $this->work->isGenerator($isGenerator);
        return $this;
    }
}