<?php
namespace boru\dhprocess;

use boru\dhprocess\traits\TaskCallbacks;
use boru\dhprocess\traits\TaskDisplay;
use boru\dhprocess\traits\TaskGettersSetters;

class TaskGroup {
    use TaskGettersSetters;
    use TaskDisplay;
    use TaskCallbacks;

    /** @var mixed */
    private $id;
    /** @var mixed */
    private $name;
    /** @var bool */
    private $collectResults=false;

    /** @var bool */
    private $started = false;
    /** @var bool */
    private $done = false;

    private $results = [];
    private $pendingTasks = [];

    private $onDoneCallback=[];
    private $onErrorCallback=[];
    private $onStartCallback=[];
    private $onQueueCallback=[];
    private $onFinalCallback=[];

    private $showDone=false;
    private $showStart=false;
    private $showQueued=false;
    private $showDetailed=false;

    private $cleanupOnDone=false;

    private $data;
    private $error;
    private $description;

    public function __construct($name=null,$collectResults=false) {
        $this->id(uniqid());
        $this->name(is_null($name) ? $this->id : $name);
        $this->collectResults($collectResults);
    }

    public function id($id=null) {
        if(is_null($id)) return $this->id;
        $this->id = $id;
        return $this;
    }
    public function name($name=null) {
        if(is_null($name)) return $this->name;
        $this->name = $name;
        return $this;
    }
    public function displayName() {
        if(is_null($this->description)) {
            return $this->name();
        }
        return $this->name()." : ".$this->description();
    }
    public function description($description=null) {
        if(is_null($description)) return $this->description;
        $this->description = $description;
        return $this;
    }
    public function collect() {
        return $this->results;
    }
    public function collectResults($collectResults=null) {
        if(is_null($collectResults)) return $this->collectResults;
        $this->collectResults = $collectResults;
        return $this;
    }
    public function Task($name,$args=[]) {
        $task = new Task($name,$args);
        $this->pendingTasks[$task->id()] = null;
        $this->done=false;
        $task->onDone(function($result) use ($task) {
            if($this->collectResults) {
                $this->results[$task->id()] = $result;
            }
        });
        $task->lastly(function($result) use ($task) {
            $this->checkDone($task->id());
        });
        if(!$this->started) {
            $task->onStart(function() {
                $this->checkStarted();
            });
        }
        $task->setVerbosity($this->showStart,$this->showQueued,$this->showDone,$this->showDetailed);
        return TaskQueue::queue($task,true);
    }

    private function checkDone($taskId=null) {
        if(!is_null($taskId)) {
            unset($this->pendingTasks[$taskId]);
        }
        if(empty($this->pendingTasks)) {
            $this->callbackOnDone($this->results);
        }
    }
    private function checkStarted() {
        if($this->started) { 
            return;
        }
        $this->started=true;
        $this->callbackOnStart();
    }
}