<?php
namespace boru\dhprocess\config;

use boru\dhutils\dhGlobal;

class Config {
    /** @var QueueConfig */
    private $queueConfig;
    /** @var WorkerConfig */
    private $workerConfig;
    /** @var WorkConfig */
    private $workConfig;

    private $data = [
        //verbosity
        "start"     => false,
        "queue"     => false,
        "done"      => false,
        "detail"    => false,
        //queue config
        "numWorkers"            => 3,
        "maxQueued"             => 0,
        "visualize"             => true,
        "log"                   => false,
        "extendedBar"           => false,
        "threadStatusInterval"  => 60,
        "maxIdleTime"           => 300,
        "idleUpdateInterval"    => 10,
        "threadTemplate"        => "[{lastTime|since|timeFormat} {workDone} {status|max:10|pad:10}]",
        "summaryTemplate"       => "{id}   |  {lastTime|since|timeFormat|pad:8}   |  Mem:{memUsed|formatBytes} / done:{workDone|pad:3}  |  {description|max:100}",
        "idleUpdateTemplate"    => "Queued: {queued}, Active: {active}   |   Workers: {workers} total, {activeWorkers} active",
        //worker config
        "bootstrapFile"     => null,
        "bootstrapCallable" => null,
        "timeout"           => 0,
        "killOnError"       => false,
        "maxWork"           => 0,
        "onLog"             => null,
        //work config
        "retriesOnError"    => 0,
        "discardOnDone"     => true,
        //loging config
        "logDir"            => null,
        "logPrint"          => false,
        "logLevels" => [
            "comms"     => true,
            "error"     => true,
            "warning"   => true,
            "notice"    => true,
            "info"      => true,
            "debug"     => false,
        ],
        "errorExceptions" => false,
    ];

    private static $logLevelCompressMap = [
        "comms"     => "c",
        "error"     => "e",
        "warning"   => "w",
        "notice"    => "n",
        "info"      => "i",
        "debug"     => "d",
    ];
    private static $logLevelCompressReverseMap = [
        "c" => "comms",
        "e" => "error",
        "w" => "warning",
        "n" => "notice",
        "i" => "info",
        "d" => "debug",
    ];

    public function __construct($options=[]) {
        $this->set("onLog",function($proc,$message) {  $this->onLogDefault($proc,$message); });
        $this->applyOptions($options);
    }

    public function applyOptions($options=[]) {
        if(is_object($options)) {
            $this->applyOptions($options->get());
        } elseif(is_array($options)) {
            foreach($options as $k=>$v) {
                $this->set($k,$v);
            }
        }
       
    }

    public function verbosity($verbosity=null) {
        if(is_null($verbosity)) return [
            "start"=>$this->get("start"),
            "queue"=>$this->get("queue"),
            "done"=>$this->get("done"),
            "detail"=>$this->get("detail"),
        ];
        foreach($verbosity as $k=>$v) {
            $this->set($k,$v);
        }
        return $this;
    }

    public function get($key=null,$default=null) {
        if(is_null($key)) return $this->data;
        return dhGlobal::dotGet($this->data,$key,$default);
    }
    public function set($key,$value=null) {
        if(is_array($key)) {
            foreach($key as $k=>$v) {
                $this->set($k,$v);
            }
            return $this;
        }
        if(strpos($key,".")!==false) {
            dhGlobal::dotAssign($this->data,$key,$value);
            return $this;
        }
        $this->data[$key] = $value;
        //echo "Set $key to $value\n";
        return $this;
    }

    public function getLogLevels() {
        return $this->get("logLevels");
    }

    public function logLevelsToTransport() {
        $logLevels = $this->get("logLevels");
        $string = "";
        foreach($logLevels as $k=>$v) {
            if($v && isset(static::$logLevelCompressMap[$k])) {

                $string.= static::$logLevelCompressMap[$k];
            }
        }
        return $string;
    }
    public function logLevelsFromTransport($string) {
        $logLevels = $this->getLogLevels();
        foreach($logLevels as $k=>$v) {
            $logLevels[$k] = false;
        }
        for($i=0;$i<strlen($string);$i++) {
            $k = $string[$i];
            if(isset(static::$logLevelCompressReverseMap[$k])) {
                $k = static::$logLevelCompressReverseMap[$k];
                $logLevels[$k] = true;
            }
        }
        $this->set("logLevels",$logLevels);
        return $this;
    }

    /**
     * Set or Get the value of numWorkers
     * @param mixed $numWorkers 
     * @param mixed $default 
     * @return mixed 
     */
    public function numWorkers($numWorkers=null,$default=null) {
        if(is_null($numWorkers)) return $this->get("numWorkers",$default);
        $this->set("numWorkers",$numWorkers);
        return $this;
    }
    /**
     * Set or Get the value of maxQueued
     * @param mixed $maxQueued 
     * @param mixed $default 
     * @return mixed 
     */
    public function maxQueued($maxQueued=null,$default=null) {
        if(is_null($maxQueued)) return $this->get("maxQueued",$default);
        $this->set("maxQueued",$maxQueued);
        return $this;
    }
    /**
     * Set or Get the value of visualize
     * @param mixed $visualize 
     * @param mixed $default 
     * @return mixed 
     */
    public function visualize($visualize=null,$default=null) {
        if(is_null($visualize)) return $this->get("visualize",$default);
        $this->set("visualize",$visualize);
        return $this;
    }
    /**
     * Set or Get the value of extendedBar
     * @param mixed $extendedBar 
     * @param mixed $default 
     * @return mixed 
     */
    public function extendedBar($extendedBar=null,$default=null) {
        if(is_null($extendedBar)) return $this->get("extendedBar",$default);
        $this->set("extendedBar",$extendedBar);
        return $this;
    }
    /**
     * Set or Get the value of log
     * @param mixed $log 
     * @param mixed $default 
     * @return self|mixed 
     */
    public function log($log=null,$default=null) {
        if(is_null($log)) return $this->get("log",$default);
        $this->set("log",$log);
        return $this;
    }
    /**
     * Set or Get the value of threadStatusInterval
     * @param mixed $threadStatusInterval 
     * @param mixed $default 
     * @return self|int|false 
     */
    public function threadStatusInterval($threadStatusInterval=null,$default=null) {
        if(is_null($threadStatusInterval)) return $this->get("threadStatusInterval",$default);
        $this->set("threadStatusInterval",$threadStatusInterval);
        return $this;
    }
    /**
     * Set or Get the value of maxIdleTime
     * @param mixed $maxIdleTime 
     * @param mixed $default 
     * @return self|int|false 
     */
    public function maxIdleTime($maxIdleTime=null,$default=null) {
        if(is_null($maxIdleTime)) return $this->get("maxIdleTime",$default);
        $this->set("maxIdleTime",$maxIdleTime);
        return $this;
    }
    /**
     * Set or Get the value of idleUpdateInterval
     * @param mixed $idleUpdateInterval 
     * @param mixed $default 
     * @return self|int|false
     */
    public function idleUpdateInterval($idleUpdateInterval=null,$default=null) {
        if(is_null($idleUpdateInterval)) return $this->get("idleUpdateInterval",$default);
        $this->set("idleUpdateInterval",$idleUpdateInterval);
        return $this;
    }
    
    /**
     * Set or Get the value of threadTemplate
     * @param mixed $threadTemplate 
     * @param mixed $default 
     * @return self|string|false 
     */
    public function threadTemplate($threadTemplate=null,$default=null) {
        if(is_null($threadTemplate)) return $this->get("threadTemplate",$default);
        $this->set("threadTemplate",$threadTemplate);
        return $this;
    }
    /**
     * Set or Get the value of summaryTemplate
     * @param mixed $summaryTemplate 
     * @param mixed $default 
     * @return self|string|false 
     */
    public function summaryTemplate($summaryTemplate=null,$default=null) {
        if(is_null($summaryTemplate)) return $this->get("summaryTemplate",$default);
        $this->set("summaryTemplate",$summaryTemplate);
        return $this;
    }
    /**
     * Set or Get the value of idleUpdateTemplate
     * @param mixed $idleUpdateTemplate 
     * @param mixed $default 
     * @return self|string|false 
     */
    public function idleUpdateTemplate($idleUpdateTemplate=null,$default=null) {
        if(is_null($idleUpdateTemplate)) return $this->get("idleUpdateTemplate",$default);
        $this->set("idleUpdateTemplate",$idleUpdateTemplate);
        return $this;
    }

    /**
     * Set or Get the value of retriesOnError
     * @param mixed $retriesOnError 
     * @param mixed $default 
     * @return mixed 
     */
    public function retriesOnError($retriesOnError=null,$default=null) {
        if(is_null($retriesOnError)) return $this->get("retriesOnError",$default);
        $this->set("retriesOnError",$retriesOnError);
        return $this;
    }
    /**
     * Set or Get the value of discardOnDone
     * @param mixed $discardOnDone 
     * @param mixed $default 
     * @return mixed 
     */
    public function discardOnDone($discardOnDone=null,$default=null) {
        if(is_null($discardOnDone)) return $this->get("discardOnDone",$default);
        $this->set("discardOnDone",$discardOnDone);
        return $this;
    }

    /**
     * Set or Get the value of bootstrapFile
     * @param mixed $bootstrapFile 
     * @param mixed $default 
     * @return mixed 
     */
    public function bootstrapFile($bootstrapFile=null,$default=null) {
        if(is_null($bootstrapFile)) return $this->get("bootstrapFile",$default);
        $this->set("bootstrapFile",$bootstrapFile);
        return $this;
    }
    /**
     * Set or Get the value of bootstrapCallable
     * @param mixed $bootstrapCallable 
     * @param mixed $default 
     * @return mixed 
     */
    public function bootstrapCallable($bootstrapCallable=null,$default=null) {
        if(is_null($bootstrapCallable)) return $this->get("bootstrapCallable",$default);
        $this->set("bootstrapCallable",$bootstrapCallable);
        return $this;
    }
    /**
     * Set or Get the value of timeout
     * @param mixed $timeout 
     * @param mixed $default 
     * @return mixed 
     */
    public function timeout($timeout=null,$default=null) {
        if(is_null($timeout)) return $this->get("timeout",$default);
        $this->set("timeout",$timeout);
        return $this;
    }
    /**
     * Set or Get the value of killOnError
     * @param mixed $killOnError 
     * @param mixed $default 
     * @return mixed 
     */
    public function killOnError($killOnError=null,$default=null) {
        if(is_null($killOnError)) return $this->get("killOnError",$default);
        $this->set("killOnError",$killOnError);
        return $this;
    }
    /**
     * Set or Get the value of maxWork
     * @param mixed $maxWork 
     * @param mixed $default 
     * @return mixed 
     */
    public function maxWork($maxWork=null,$default=null) {
        if(is_null($maxWork)) return $this->get("maxWork",$default);
        $this->set("maxWork",$maxWork);
        return $this;
    }
    /**
     * Set or Get the value of logDir
     * @param mixed $logDir 
     * @param mixed $default 
     * @return mixed 
     */
    public function logDir($logDir=null,$default=null) {
        if(is_null($logDir)) return $this->get("logDir",$default);
        if($logDir!==false) { 
            if(substr($logDir,0,1) != "/") { 
                $cwd = getcwd(); 
                if(substr($cwd,-1) != "/") { 
                    $cwd .="/"; 
                } 
                $logDir = $cwd.$logDir; 
            }
        }
        $this->set("logDir",$logDir);
        return $this;
    }
    /**
     * Set or Get the value of logPerWorker
     * @param null|bool $logPerWorker 
     * @param null|bool $default 
     * @return mixed 
     */
    public function logPerWorker($logPerWorker=null,$default=null) {
        if(is_null($logPerWorker)) return $this->get("logPerWorker",$default);
        $this->set("logPerWorker",$logPerWorker);
        return $this;
    }

    /**
     * Set or Get the value of onLog
     * @param null|callable $onLogCallable 
     * @return mixed 
     */
    public function onLog($onLogCallable=null) {
        if(is_null($onLogCallable)) return $this->get("onLog");
        $this->set("onLog",$onLogCallable);
        return $this;
    }

    public function onLogDefault($proc,$message) { 
        if($this->get("logPrint",false) && $this->get("logLevels.".strtolower($message->get("level")),true)) {
            $level = "|".dhGlobal::padLeft(strtoupper($message->get("level")),7," ")."  | ";
            dhGlobal::outLine($level,"WC-".$proc->getId()." | ",$message->get("message"));
        }
    }
}