<?php
namespace boru\dhprocess\config;

use boru\dhutils\dhGlobal;

class WorkerConfig extends BaseConfig {
    protected $data = [
        "bootstrapFile"=>null,
        "bootstrapCallable"=>null,
        "timeout"=>0,
        "killOnError"=>false,
        "maxWork"=>0,
        "logDir"=>null,
        "onLog"=>null,
    ];
    /**
     * Set or Get the value of bootstrapFile
     * @param mixed $bootstrapFile 
     * @param mixed $default 
     * @return mixed 
     */
    public function bootstrapFile($bootstrapFile=null,$default=null) {
        if(is_null($bootstrapFile)) return $this->get("bootstrapFile",$default);
        $this->set("bootstrapFile",$bootstrapFile);
        return $this;
    }
    /**
     * Set or Get the value of bootstrapCallable
     * @param mixed $bootstrapCallable 
     * @param mixed $default 
     * @return mixed 
     */
    public function bootstrapCallable($bootstrapCallable=null,$default=null) {
        if(is_null($bootstrapCallable)) return $this->get("bootstrapCallable",$default);
        $this->set("bootstrapCallable",$bootstrapCallable);
        return $this;
    }
    /**
     * Set or Get the value of timeout
     * @param mixed $timeout 
     * @param mixed $default 
     * @return mixed 
     */
    public function timeout($timeout=null,$default=null) {
        if(is_null($timeout)) return $this->get("timeout",$default);
        $this->set("timeout",$timeout);
        return $this;
    }
    /**
     * Set or Get the value of killOnError
     * @param mixed $killOnError 
     * @param mixed $default 
     * @return mixed 
     */
    public function killOnError($killOnError=null,$default=null) {
        if(is_null($killOnError)) return $this->get("killOnError",$default);
        $this->set("killOnError",$killOnError);
        return $this;
    }
    /**
     * Set or Get the value of maxWork
     * @param mixed $maxWork 
     * @param mixed $default 
     * @return mixed 
     */
    public function maxWork($maxWork=null,$default=null) {
        if(is_null($maxWork)) return $this->get("maxWork",$default);
        $this->set("maxWork",$maxWork);
        return $this;
    }
    /**
     * Set or Get the value of logDir
     * @param mixed $logDir 
     * @param mixed $default 
     * @return mixed 
     */
    public function logDir($logDir=null,$default=null) {
        if(is_null($logDir)) return $this->get("logDir",$default);
        if($logDir!==false) { 
            if(substr($logDir,0,1) != "/") { 
                $cwd = getcwd(); 
                if(substr($cwd,-1) != "/") { 
                    $cwd .="/"; 
                } 
                $logDir = $cwd.$logDir; 
            }
        }
        $this->set("logDir",$logDir);
        return $this;
    }
    /**
     * Set or Get the value of logPerWorker
     * @param null|bool $logPerWorker 
     * @param null|bool $default 
     * @return mixed 
     */
    public function logPerWorker($logPerWorker=null,$default=null) {
        if(is_null($logPerWorker)) return $this->get("logPerWorker",$default);
        $this->set("logPerWorker",$logPerWorker);
        return $this;
    }

    /**
     * Set or Get the value of onLog
     * @param null|callable $onLogCallable 
     * @return mixed 
     */
    public function onLog($onLogCallable=null) {
        if(is_null($onLogCallable)) return $this->get("onLog");
        $this->set("onLog",$onLogCallable);
        return $this;
    }

    public function callOnLog($process,$message) {
        $callable = $this->get("onLog");
        if(is_callable($callable)) {
            $callable($process,$message);
        } elseif(is_null($callable)) {
            if($message->get("level") == "error") {
                dhGlobal::outLine("****",strtoupper($message->get("level")),"|","WC-".$process->getId(),"|",$message->get("message"));
            }
        }
    }
}