<?php
namespace boru\dhprocess\message;

use boru\dhutils\dhGlobal;

class Message {

    private static $startDelimiter = "#";
    private static $endDelimiter = "#";
    private static $typeDelimiter = "$";

    const E_FRAME_ERROR = "frame_error";
    const E_UNKNOWN_FRAME = "unknown_frame";
    const E_NOT_CALLABLE = "not_callable";
    const E_EXECUTE_EXCEPTION = "execute_exception";
    const E_BOOSTRAPPED_ALREADY = "bootstrapped_already";
    const E_BOOTSTRAP_INVALID = "bootstrap_invalid";
    const E_BOOTSTRAP_NOT_FOUND = "bootstrap_not_found";
    const E_BOOTSTRAP_NOT_CALLABLE = "boostrap_not_callable";

    const ENCODING_PLAIN = "plain";
    const ENCODING_BASE64 = "base64";
    
    private $workId;
    private $data;
    private $rawPacket;
    private $encoding;
    private $error;
    private $time;
    private $mem;
    private $isGenerator = false;

    public function __construct($encoding=Message::ENCODING_PLAIN) {
        $this->encoding = $encoding;
    }
    public function isValid() {
        return !empty($this->data);
    }
    public function isError() {
        return !empty($this->error);
    }
    public function toDisplay($len=150) {
        $packet = $this->toPacket();
        if(strlen($packet)>$len) {
            $packet = substr($packet,0,$len-4)." ...";
        }
        return $packet;
    }
    public function toPacket() {
        if(empty($this->data) && empty($this->error)) {
            return false;
        }
        $packet = json_encode(["workId"=>$this->workId,"message"=>$this->data,"error"=>$this->error,"time"=>$this->time,"mem"=>$this->mem,"isGenerator"=>$this->isGenerator],JSON_UNESCAPED_SLASHES);
        $packetData = static::encode($packet,$this->encoding);
        $packet = static::$startDelimiter;
        $packet .= $this->encoding;
        $packet .= static::$typeDelimiter;
        $packet .= $packetData;
        $packet .= static::$endDelimiter;
        return $packet;
    }

    public static function fromPacket($rawPacket) {
        $instance = new self();
        $delimStart = static::$startDelimiter;
        $delimEnd = static::$endDelimiter;
        $delimType = static::$typeDelimiter;
        if(substr($rawPacket,0,strlen($delimStart)) == $delimStart && substr($rawPacket,-strlen($delimEnd)) == $delimEnd) {
            $rawPacket = substr($rawPacket,1);
            $rawPacket = substr($rawPacket,0,-1);
            $parts = explode($delimType,$rawPacket,2);
            if(count($parts) !== 2) {
                return false;
            }
            $instance->setEncoding($parts[0]);
            $instance->setRawPacket($parts[1]);
            $json = json_decode($parts[1],true);
            if(is_array($json)) {
                $instance->setWorkId(dhGlobal::getVal($json,"workId",null));
                $instance->setData(dhGlobal::getVal($json,"message",null));
                $instance->setError(dhGlobal::getVal($json,"error",null));
                $instance->time(dhGlobal::getVal($json,"time",null));
                $instance->mem(dhGlobal::getVal($json,"mem",null));
                $instance->isGenerator(dhGlobal::getVal($json,"isGenerator",false));
            }
            return $instance;
        }
        return false;
    }
    
    public static function encode($packet,$type=Message::ENCODING_BASE64) {
        if($type == Message::ENCODING_BASE64) {
            return base64_encode($packet);
        }
        return $packet;
    }
    public static function decode($packet,$type=Message::ENCODING_BASE64) {
        if($type == Message::ENCODING_BASE64) {
            return base64_decode($packet);
        }
        return $packet;
    }

    public function set($key,$val="") {
        dhGlobal::dotAssign($this->data,$key,$val);
        return $this;
    }
    public function get($key=null,$default=null,$exists=false) {
        if(is_null($key)) {
            if($exists) {
                return !empty($this->data) ? true : false;
            } else {
                return !empty($this->data) ? $this->data : $default;
            }
        }
        $uniqueid = uniqid("getArray",true);
        if(($check = dhGlobal::getDot($this->data,$key,$uniqueid,".")) !== $uniqueid) {
            return $exists ? true : $check;
        };
        return $default;
    }
    public function exists($key=null) {
        return $this->get($key,null,true);
    }
    public function remove($key) {
        unset($this->data[$key]);
        return $this;
    }

    /**
     * Get the value of encoding
     */ 
    public function getEncoding()
    {
        return $this->encoding;
    }

    /**
     * Set the value of encoding
     *
     * @return  self
     */ 
    public function setEncoding($encoding)
    {
        $this->encoding = $encoding;

        return $this;
    }

    /**
     * Get the value of workId
     */ 
    public function getWorkId()
    {
        return $this->workId;
    }

    /**
     * Set the value of workId
     *
     * @return  self
     */ 
    public function setWorkId($workId)
    {
        $this->workId = $workId;

        return $this;
    }

    /**
     * Get the value of rawPacket
     */ 
    public function getRawPacket()
    {
        return $this->rawPacket;
    }

    /**
     * Set the value of rawPacket
     *
     * @return  self
     */ 
    public function setRawPacket($rawPacket)
    {
        $this->rawPacket = $rawPacket;

        return $this;
    }

    /**
     * Get the value of data
     */ 
    public function getData()
    {
        return $this->data;
    }

    /**
     * Set the value of data
     *
     * @return  self
     */ 
    public function setData($data)
    {
        $this->data = $data;

        return $this;
    }

    /**
     * Get the value of error
     *
     * @return  mixed
     */
    public function getError() {
        return $this->error;
    }

    /**
     * Set the value of error
     *
     * @param   mixed  $error  
     * @return  self
     */
    public function setError($error) {
        $this->error = $error;
        return $this;
    }
    public function time($time=null) {
        if(is_null($time)) return $this->time;
        $this->time = $time;
    }
    public function mem($mem=null) {
        if(is_null($mem)) return $this->mem;
        $this->mem = $mem;
    }
    public function isGenerator($isGenerator=null) {
        if(is_null($isGenerator)) return $this->isGenerator;
        $this->isGenerator = $isGenerator;
    }

    public function data($dotKey=null,$default=null) {
        if(is_null($dotKey)) {
            return $this->getData();
        }
        if(is_null($this->data) || empty($this->data)) {
            return $default;
        }
        return dhGlobal::getVal($this->data,$dotKey,$default);
    }
    public function error($dotKey=null,$default=null) {
        if(is_null($dotKey)) {
            return $this->getError();
        }
        if(is_null($this->error) || empty($this->error)) {
            return $default;
        }
        return dhGlobal::getVal($this->error,$dotKey,$default);
    }

    /**
     * Get a Result representation of the data result
     * @return Result|false 
     */
    public function getDataObject() {
        if(!is_null($this->data)) {
            return new Result($this->data,$this->workId,false);
        }
        return false;
    }
    /**
     * Get a Result representation of the error result
     * @return Result|false 
     */
    public function getErrorObject() {
        if(!is_null($this->error)) {
            return new Result($this->error,$this->workId,true);
        }
        return false;
    }
}