<?php
namespace boru\dhprocess\queue;

use boru\dhutils\dhGlobal;
use boru\dhutils\dhOut;
use boru\dhprocess\queue\Queue;
use boru\dhprocess\queue\QueueWorker;
use boru\dhprocess\process\WorkerProcess;
use boru\dhprocess\config\Config;

class QueueLogger {
    private static $logPerWorker = false;
    private static $logDir = null;
    private static $clientId;

    private static $logFilePrefix;

    private static $logFiles = [];

    /** @var QueueWorker|WorkerProcess|\Worker|Queue */
    private static $object;

    /** @var Config */
    private static $config;

    private static $logPrefix = [
        "queue"=>"QQ-",
        "worker"=>"QW-",
        "process"=>"WP-",
        "client"=>"WC-",
    ];
    public static function setConfig($config) {
        static::$config = $config;
    }
    public static function getConfig() {
        return static::$config;
    }
    public static function initSettings($logDir=null,$logPerWorker=null) {
        if(!is_null($logDir) && !empty($logDir)) {
            static::logDir($logDir);
        }
        if(!is_null($logPerWorker)) {
            static::logPerWorker($logPerWorker);
        }
        if(!static::logFilePrefix()) {
            static::logFilePrefix(date("YmdHis"));
        }
        static::initLogDir();        
    }
    /**
     * @param QueueWorker|WorkerProcess|\Worker|Queue $object
     * @return void 
     */
    public static function setObject($object,$logDir=null,$logPerWorker=null) {
        static::$object = $object;
        static::initSettings($logDir,$logPerWorker);
        if($object instanceof \Worker) {
        } else {
            static::setConfig($object->getQueueConfig());
            static::setLogFileByObject($object);
        }
    }
    public static function initClient($clientId=null,$logFile=null) {
        static::setConfig(new Config());
        if(!empty($logFile)) {
            static::clientId($clientId);
            static::$logFiles[$clientId]["file"] = $logFile;
            static::$logFiles[$clientId]["error"] = str_replace(".log","_error.log",$logFile);
            static::$logDir = true;
            ini_set("log_errors",true);
            ini_set("dispaly_errors","off");
            ini_set('error_log', static::getErrorLogFile($clientId));

            dhGlobal::logger("debugger",dhGlobal::LOG_ALL,false,static::getLogFile($clientId));
            dhGlobal::set("out",new dhOut(false,static::getLogFile($clientId),true,"date:H:i:s"," ($clientId:stdout) "));
            dhGlobal::set("asyncLog",true);
        }
    }
    public static function initLogDir() {
        if(is_null(static::$logDir)) {
            return false;
        }
        elseif(static::$logDir === true) {
            return true;
        }
        if(!is_dir(static::$logDir)) {
           exec("mkdir -p ".static::$logDir);
        }
    }

    public static function logPerWorker($logPerWorker=null) {
        if(!is_null($logPerWorker)) {
            static::$logPerWorker = $logPerWorker;
        }
        return static::$logPerWorker;
    }
    public static function logDir($logDir=null) {
        if(!is_null($logDir)) {
            static::$logDir = $logDir;
        }
        return static::$logDir;
    }

    public static function clientId($clientId=null) {
        if(!is_null($clientId)) {
            static::$clientId = $clientId;
        }
        return static::$clientId;
    }
    public static function logFilePrefix($logFilePrefix=null) {
        if(!is_null($logFilePrefix)) {
            static::$logFilePrefix = $logFilePrefix;
        }
        return static::$logFilePrefix;
    }

    /**
     *  
     * @param mixed $level 
     * @param mixed $args 
     * @return false|void 
     */
    public static function log($object,$level,...$args) {
        if($object instanceof \Worker) {
            $logArgs = $args;
            array_shift($logArgs);
            foreach($logArgs as $arg) {
                $parts[] = static::argToString($arg);
            }
            $object->sendLogMessage(implode(" ",$parts),$level);
        }
        if(!static::$logDir && !static::$clientId) {
            return false;
        }
        $fileName = static::getLogFile($object);
        if($level == "error") {
            $fileName = static::getErrorLogFile($object);
        }
        $level = "|".dhGlobal::padLeft(strtoupper($level),7," ")."  | ";
        array_unshift($args,$level);
        $line = static::argsToLine($args);
        file_put_contents($fileName,$line."\n",FILE_APPEND);
        return true;

    }
    public static function debug($what,...$args) {
        if(!static::$config->get("logLevels.debug",false)) {
            return false;
        }
        array_unshift($args,static::getPrefix($what));
        return static::log($what,"debug",...$args);
    }
    public static function msgSend($what,...$args) {
        if(!static::$config->get("logLevels.comms",false)) {
            return false;
        }
        array_unshift($args,"  -->  ");
        array_unshift($args,static::getPrefix($what));
        return static::log($what,"comms",...$args);
    }
    public static function msgRecv($what,...$args) {
        if(!static::$config->get("logLevels.comms",false)) {
            return false;
        }
        array_unshift($args,"  <--  ");
        array_unshift($args,static::getPrefix($what));
        return static::log($what,"comms",...$args);
    }
    public static function info($what,...$args) {
        if(!static::$config->get("logLevels.info",false)) {
            return false;
        }
        array_unshift($args,static::getPrefix($what));
        return static::log($what,"info",...$args);
    }
    public static function notice($what,...$args) {
        if(!static::$config->get("logLevels.notice",false)) {
            return false;
        }
        array_unshift($args,static::getPrefix($what));
        return static::log($what,"notice",...$args);
    }
    public static function warning($what,...$args) {
        if(!static::$config->get("logLevels.warning",false)) {
            return false;
        }
        array_unshift($args,static::getPrefix($what));
        return static::log($what,"warning",...$args);
    }
    public static function error($what,...$args) {
        if(!static::$config->get("logLevels.error",false)) {
            return false;
        }
        array_unshift($args,static::getPrefix($what));
        return static::log($what,"error",...$args);
    }

    public static function getPrefix($what) {
        if($what instanceof Queue) {
            return "QQ-".$what->id();
        }
        if($what instanceof QueueWorker) {
            return "QW-".$what->getId();;
        }
        if($what instanceof WorkerProcess) {
            return "WP-".$what->id();
        }
        if($what instanceof \Worker) {
            return "WC-".$what->id();
        }
        if(!is_object($what)) {
            if(is_array($what)) {
                return implode(" ",$what);
            }
            return isset(static::$logPrefix[$what]) ? static::$logPrefix[$what] : $what;
        }
    }
    public static function getLogFile($id) {
        if(is_object($id)) {
            $id = $id->id();
        }
        if(isset(static::$logFiles[$id])) {
            return static::$logFiles[$id]["file"];
        }
        return false;
    }
    public static function getErrorLogfile($id) {
        if(is_object($id)) {
            $id = $id->id();
        }
        if(isset(static::$logFiles[$id])) {
            return static::$logFiles[$id]["error"];
        }
        return false;
    }
    public static function setLogFileByObject($what) {
        $filePrefix = static::$logDir.DIRECTORY_SEPARATOR.static::logFilePrefix()."_";
        if($what instanceof Queue) {
            $workerLog = $filePrefix.$what->id().".log";
            $errorLog = $filePrefix.$what->id()."_error.log";
        } else {
            if(static::logPerWorker()) {
                $workerLog = $filePrefix.$what->queueId()."_".$what->queueWorkerId().".log";
                $errorLog = $filePrefix.$what->queueId()."_".$what->queueWorkerId()."_error.log";
            } else {
                $workerLog = $filePrefix.$what->queueId()."_worker.log";
                $errorLog = $filePrefix.$what->queueId()."_worker_error.log";
            }
        }
        static::$logFiles[$what->id()]["file"] = $workerLog;
        static::$logFiles[$what->id()]["error"] = $errorLog;
        if($what instanceof QueueWorker) {
            static::$logFiles["default"] = static::$logFiles[$what->id()];
        }
    }
    protected static function argsToLine($args) {
        $line = date("H:i:s")." ";
        $parts = [];
        foreach($args as $arg) {
            $parts[] = static::argToString($arg)." ";
        }
        return $line.implode(" ",$parts);
    }
    protected static function argToString($arg) {
        if(is_array($arg) || is_object($arg)) {
            return print_r($arg,true);
        } else {
            return $arg;
        }
    }
}