<?php
namespace boru\dhsession\handlers;

use boru\dhsession\Session;

class DefaultHandler extends HandlerInterface {

    public function __construct($options=[]) {
        $this->setOptions($options);
        //session_set_save_handler($this, true);
    }

    public function init() {
        //parent::init();
        return true;
    }

    public function close() {
        session_write_close();
        return true;
     }

    public function destroy($id) {
        session_destroy();
        return true;
    }

    public function gc($max_lifetime) {
        return true;
    }

    public function open($path, $name) {
        return true;
    }

    public function read($id) {
        return $_SESSION;
    }

    public function write($id, $data) {
        $_SESSION = $data;
        return true;
    }

    public function refresh($newId=null) {
        if($newId) {
            session_id($newId);
        } else {
            session_regenerate_id();
        }
        $_SESSION = Session::unserialize($this->read(session_id()));
        return true;
    }

    public function readRaw($id) {
        return $_SESSION;
    }

    public function listSessions() {

    }
    public function listByIp($ip) {

    }
    public function listByUserAgent($userAgent) {

    }
    public function listByMetaId($metId) {
        
    }
}