<?php
namespace boru\dhsession\lib;

abstract class SessionHandler implements \SessionHandlerInterface {
    /**
     * @return bool
     */
    abstract public function close();

    /**
     * @return bool
     */
    abstract public function destroy($id);

    /**
     * @return bool
     */
    abstract public function gc($max_lifetime);

    /**
     * @return bool
     */
    abstract public function open($path, $name);

    /**
     * @return string|false
     */
    abstract public function read($id);

    /**
     * @return bool
     */
    abstract public function write($id, $data);

    /**
     * @return bool
     */
    abstract public function refresh();
}