<?php
namespace boru\dhsession;

use boru\dhsession\handlers\HandlerInterface;

class Session {
    /**
     * @var HandlerInterface $handler
     */
    private static $handler;

    /**
     * @var bool $hasInit
     */
    private static $hasInit = false;

    public static function setHandler($handler,$args=[]) {
        if($handler instanceof HandlerInterface) {
            self::$handler = $handler;
        } else {
            try {
                self::$handler = self::createHandler($handler,$args);
            } catch(\Exception $e) {
                self::$handler = self::createHandler("default",$args);
            }
        }
        self::$handler->init();
        self::$hasInit = true;
    }
    public static function getHandler() {
        return self::$handler;
    }
    public static function createHandler($type="default",$options=[]) {
        $class = "boru\\dhsession\\handlers\\".ucfirst($type)."Handler";
        if(!class_exists($class)) {
            throw new \Exception("Handler $type not found");
        }
        return new $class($options);
    }
    public static function start($handler=null) {
        if($handler) {
            self::setHandler($handler);
        }
        if(self::$handler->start()) {
            /*$data = self::$handler->read(session_id());
            if($data && !is_array($data)) {
                $_SESSION = self::unserialize($data);
            }*/
        }
    }
    public static function get($key,$force=false) {
        self::start();
        if($force) {
            $_SESSION = self::getSession(self::getId());
        }
        return isset($_SESSION[$key]) ? $_SESSION[$key] : null;
    }
    public static function set($key, $value,$force=false) {
        self::start();
        if($force) {
            $_SESSION = self::getSession(self::getId());
        }
        $_SESSION[$key] = $value;
        if($force) {
            self::setSession(self::getId(),$_SESSION);
        }
    }
    public static function setId($id) {
        self::start();
        self::$handler->setSessionId($id);
    }
    public static function delete($key) {
        self::start();
        unset($_SESSION[$key]);
    }
    public static function destroy() {
        self::start();
        session_destroy();
    }
    public static function refresh($newId=null) {
        self::start();
        self::$handler->refresh($newId);
    }
    public static function getId() {
        self::start();
        return self::$handler->getSessionId();
    }
    public static function getName() {
        self::start();
        return self::$handler->getSessionName();
    }
    public static function setMetaId($metId) {
        self::start();
        self::$handler->setMetaId($metId);
    }
    public static function getMetaId() {
        self::start();
        return self::$handler->getMetaId();
    }


    //Management functions
    public static function getSession($sessionId) {
        $data = self::$handler->read($sessionId);
        return $data ? unserialize($data) : null;
    }
    public static function setSession($sessionId, $data) {
        self::$handler->write($sessionId, serialize($data));
        return true;
    }
    public static function deleteSession($sessionId,$key=null) {
        if($key) {
            $data = self::getSession($sessionId);
            unset($data[$key]);
            self::setSession($sessionId,$data);
            return true;
        } else {
            self::$handler->destroy($sessionId);
            return true;
        }
    }
    public static function destroySession($sessionId) {
        self::$handler->destroy($sessionId);
        return true;
    }
    public static function gc() {
        if(!self::$handler) {
            throw new \Exception("Session Handler not initialized");
        }
        self::$handler->gc(ini_get('session.gc_maxlifetime'));
        return true;
    }
    public static function listSessions($key=null,$value=null) {
        if($key == "ip") {
            return self::$handler->listByIp($value);
        } elseif($key == "metaId") {
            return self::$handler->listByMetaId($value);
        } elseif($key == "userAgent") {
            return self::$handler->listByUserAgent($value);
        } else {
            return self::$handler->listSessions();
        }
    }
    public static function unserialize($session_data) {
        $method = ini_get("session.serialize_handler");
        switch ($method) {
            case "php":
                return self::unserialize_php($session_data);
                break;
            case "php_binary":
                return self::unserialize_phpbinary($session_data);
                break;
            default:
                throw new \Exception("Unsupported session.serialize_handler: " . $method . ". Supported: php, php_binary");
        }
    }

    private static function unserialize_php($session_data) {
        $return_data = array();
        $offset = 0;
        while ($offset < strlen($session_data)) {
            if (!strstr(substr($session_data, $offset), "|")) {
                return $return_data;
                //throw new \Exception("invalid data, remaining: " . substr($session_data, $offset));
            }
            $pos = strpos($session_data, "|", $offset);
            $num = $pos - $offset;
            $varname = substr($session_data, $offset, $num);
            $offset += $num + 1;
            $data = unserialize(substr($session_data, $offset));
            $return_data[$varname] = $data;
            $offset += strlen(serialize($data));
        }
        return $return_data;
    }

    private static function unserialize_phpbinary($session_data) {
        $return_data = array();
        $offset = 0;
        while ($offset < strlen($session_data)) {
            $num = ord($session_data[$offset]);
            $offset += 1;
            $varname = substr($session_data, $offset, $num);
            $offset += $num;
            $data = unserialize(substr($session_data, $offset));
            $return_data[$varname] = $data;
            $offset += strlen(serialize($data));
        }
        return $return_data;
    }
}