<?php
namespace boru\dhsmarty;

use boru\dhutils\dhGlobal;

class dhSmarty {
    private static $smarty;
    private static $options = [
        "templateDir" => __DIR__."/../work/templates",
        "configDir" => __DIR__."/../work/configs",
        "compileDir" => __DIR__."/../work/compiled",
        "cacheDir" => __DIR__."/../work/cache",
        "caching" => \Smarty::CACHING_OFF,
    ];
    public static function get() {
        if(self::$smarty === null) {
            self::$smarty = self::createInstance();
        }
        return self::$smarty;
    }
    public static function createInstance($options=[]) {
        $smarty = new \Smarty();
        $smarty->setTemplateDir(    isset($options["templateDir"]) ? $options["templateDir"] : static::$options["templateDir"]);
        $smarty->setConfigDir(      isset($options["configDir"])   ? $options["configDir"]   : static::$options["configDir"]);
        $smarty->setCompileDir(     isset($options["compileDir"])  ? $options["compileDir"]  : static::$options["compileDir"]);
        $smarty->setCacheDir(       isset($options["cacheDir"])    ? $options["cacheDir"]    : static::$options["cacheDir"]);
        $smarty->caching  =         isset($options["caching"])     ? $options["caching"]     : static::$options["caching"];
        if(($dir = dhGlobal::dirIfExists($smarty->getCompileDir(),false)) === false) {
            if(!mkdir($smarty->getCompileDir(),0777,true)) {
                throw new \Exception("Could not create compile dir: ".$smarty->getCompileDir());
            }
        } else {
            if(!is_writable($smarty->getCompileDir())) {
                throw new \Exception("Compile dir is not writable: ".$smarty->getCompileDir());
            }
        }
        if(($dir = dhGlobal::dirIfExists($smarty->getCacheDir(),false)) === false) {
            if(!mkdir($smarty->getCacheDir(),0777,true)) {
                throw new \Exception("Could not create cache dir: ".$smarty->getCompileDir());
            }
        } else {
            if(!is_writable($smarty->getCacheDir())) {
                throw new \Exception("Cache dir is not writable: ".$smarty->getCacheDir());
            }
        }
    }
    public static function setOption($option,$value=null) {
        if(is_array($option)) {
            foreach($option as $key=>$value) {
                static::$options[$key] = $value;
            }
        } else {
            static::$options[$option] = $value;
        }
    }
}