<?php
require __DIR__."/../vendor/autoload.php";

use boru\dhutils\dhGlobal;
use boru\dhttp\Client;
use boru\dhttp\core\Options;
use boru\dhttp\core\Request;
use boru\dhttp\HttpClient;

/**
 * This example shows how to use the Options class to configure requests
 * Optionally, you can use most of these methods directly on a Request option, see examples/request.php for more info
 */


//Send a synchronous request with query
/*$httpClient = new HttpClient();
$result = $httpClient->post("https://devl06.borugroup.com/testclient.php",[
    "query"=>[
        "q"=>"test",
    ]
]);
dhGlobal::outLine("Response:",$result->asString());
exit();
*/
//Send an asynchronous request with form
$httpClient = new HttpClient();
$result = $httpClient->post("https://devl06.borugroup.com/testclient.php",[
    "form"=>[
        "min"=>2,
        "max"=>6,
        "identifier"=>"test",
    ],
    "async"=>true,
])->then(function($response) {
    dhGlobal::outLine("Response asyncronously:",$response->asString());
});
dhGlobal::outLine("Sent async request.. now waiting for promise to resolve");
