<?php
require __DIR__."/../vendor/autoload.php";

use boru\dhutils\dhGlobal;
use boru\dhttp\Client;
use boru\dhttp\core\Options;
use boru\dhttp\core\Request;

/**
 * This example shows how to use the Request class to directly configure and send requests
 * Optionally, you can directly create/configure an Options object and pass it to the Request constructor
 */
$request = new Request();
$request->method("post");
$request->url("https://devl06.borugroup.com/testclient.php");
$request->form("sleepTime",12);
$request->form("identifier","test");
$request->async(true);
$promise = $request->send()->then(function($response) {
    //optionally do something with the response asynchronously.
    dhGlobal::outLine("Response asyncronously:",$response->asString());
});
dhGlobal::outLine("Sent async request.. now waiting for promise to resolve");
for($i=0;$i<=5;$i++) {
    $req = new Request();
    $req->method("post");
    $req->url("http://localhost/testclient.php");
    $req->form("min",0.1);
    $req->form("max",8);
    $req->form("identifier","test$i");
    $req->async(true);
    $req->send()->then(function($response) use ($i) {
        dhGlobal::outLine("recieved response $i asyncronously");
    });
}

//Wait for the promise to resolve before proceeding
$request->await();
dhGlobal::outLine("Response after waiting:",$request->response()->asString());