<?php
require __DIR__."/../vendor/autoload.php";

use boru\dhutils\dhGlobal;
use boru\dhttp\Client;
use boru\dhttp\core\Options;
use boru\dhttp\core\Request;


/**
 * This example shows how to use the Options class to configure requests
 * Optionally, you can use most of these methods directly on a Request option, see examples/request.php for more info
 */

//Send a synchronous request
$options = new Options();
$options->method("post");
$options->url("https://devl06.borugroup.com/testclient.php");
$options->query([
    "q"=>"test",
]);
$request = new Request($options);
$response = $request->send();
dhGlobal::outLine("Response:",$response->asString());

//Send an asynchronous request
$options = new Options();
$options->method("post");
$options->url("https://devl06.borugroup.com/testclient.php");
$options->form([
    "min"=>2,
    "max"=>6,
    "identifier"=>"test",
]);
$options->async(true);
$request = new Request($options);
$promise = $request->send()->then(function($response) {
    dhGlobal::outLine("Response asyncronously:",$response->asString());
});
dhGlobal::outLine("Sent async request.. now waiting for promise to resolve");

//Generating a couple of standard async requests to test concurrency
for($i=0;$i<10;$i++) {
    $opt = clone $options;
    $opt->form([
        "min"=>0.1,
        "max"=>2,
        "identifier"=>"test$i"
    ]);
    $request = new Request($opt);
    $promise = $request->send()->then(function($response) use ($i) {
        dhGlobal::outLine("recieved response $i asyncronously");
    });
}
$request->await();
dhGlobal::outLine("Response after waiting:",$request->response()->asString());


//Generating a couple of standard async requests to test concurrency
for($i=0;$i<10;$i++) {
    $opt = clone $options;
    $opt->form([
        "min"=>0.1,
        "max"=>2,
        "identifier"=>"test$i"
    ]);
    $request = new Request($opt);
    $promise = $request->send()->then(function($response) use ($i) {
        dhGlobal::outLine("recieved response $i asyncronously");
    });
}
$request->await();
dhGlobal::outLine("Response after waiting:",$request->response()->asString());
