<?php
require __DIR__."/../vendor/autoload.php";

use boru\dhutils\dhGlobal;
use boru\dhttp\Client;

//Optoional: Set the maximum number of concurrent requests if using async
Client::maxConcurrency(3);


//The shortest and easiest way to send a synchronous request
$response = Client::get("https://devl06.borugroup.com/testclient.php");
//here we use the dhGlobal::outLine() method to print the response ($response->asString()) to the console
dhGlobal::outLine("Response","sync :",$response->asString());

//The shortest and easiest way to send an synchronous request with a body
$response = Client::post("https://devl06.borugroup.com/testclient.php",[
    "form"=>[
        "q"=>"test",
    ]
]);
//here we use the dhGlobal::outLine() method to print the response ($response->asString()) to the console
dhGlobal::outLine("Response","sync :",$response->asString());


//The shortest and easiest way to send several asynchronous requests with a body
for($i=0;$i<10;$i++) {
    dhGlobal::outLine("sending async request",$i);
    Client::post("https://devl06.borugroup.com/testclient.php",[
        "form"=>[
            "q"=>"test",
        ]
    ],true)->then(function($response) {
        dhGlobal::outLine("Response","async:",$response->asString());
    });
}

//Optionally wait for the promises to resolve
dhGlobal::outLine("Waiting for promises to resolve");
Client::awaitAll();
dhGlobal::outLine("All promises resolved");

//The shortest and easiest way to send an asynchronous request
$promise1 = Client::get("https://devl06.borugroup.com/testclient.php",[],true)->then(function($response) {
    dhGlobal::outLine("Response","async:",$response->asString());
});