<?php
namespace boru\dhttp\middleware;

use boru\dhttp\middleware\MiddlewareInterface;
use boru\dhutils\dhGlobal;

class HmacAuthentication implements MiddlewareInterface {
    private $apiKey;
    private $apiSecret;

    private $headerApiKey = "x-api-key";
    private $headerApiNonce = "x-api-nonce";
    private $headerApiSign = "x-api-sign";
    private $signatureTemplate = "{APIKEY}:{NONCE}:{PATH}";
    private $hashAlgo = "sha1";
    private $withLeadingSlash = true;

    public function __invoke($object, $next) {
        $object->header($this->headerApiKey,$this->apiKey);
        $object->header($this->headerApiNonce,$this->getNonce());
        $object->header($this->headerApiSign,$this->getSignature($object));
        return $next($object);
    }

    public function __construct($apiKey,$apiSecret,$options=[]) {
        $this->apiKey = $apiKey;
        $this->apiSecret = $apiSecret;
        if(isset($options["headerApiKey"])) {
            $this->headerApiKey = $options["headerApiKey"];
        }
        if(isset($options["headerApiNonce"])) {
            $this->headerApiNonce = $options["headerApiNonce"];
        }
        if(isset($options["headerApiSign"])) {
            $this->headerApiSign = $options["headerApiSign"];
        }
        if(isset($options["signatureTemplate"])) {
            $this->signatureTemplate = $options["signatureTemplate"];
        }
        if(isset($options["hashAlgo"])) {
            $this->hashAlgo = $options["hashAlgo"];
        }
        if(isset($options["withLeadingSlash"])) {
            $this->withLeadingSlash = $options["withLeadingSlash"];
        }
    }

    public function setApiKey($apiKey) {
        $this->apiKey = $apiKey;
    }
    public function setApiSecret($apiSecret) {
        $this->apiSecret = $apiSecret;
    }
    public function setHeaderApiKey($headerApiKey) {
        $this->headerApiKey = $headerApiKey;
    }
    public function setHeaderApiNonce($headerApiNonce) {
        $this->headerApiNonce = $headerApiNonce;
    }
    public function setHeaderApiSign($headerApiSign) {
        $this->headerApiSign = $headerApiSign;
    }
    public function setSignatureTemplate($signatureTemplate) {
        $this->signatureTemplate = $signatureTemplate;
    }
    public function setHashAlgo($hashAlgo) {
        $this->hashAlgo = $hashAlgo;
    }
    public function getNonce() {
        return time();
    }
    public function getSignature($object) {
        $path = $this->getPath($object);
        $nonce = $this->getNonce();
        $signature = str_replace("{APIKEY}",$this->apiKey,$this->signatureTemplate);
        $signature = str_replace("{NONCE}",$nonce,$signature);
        $signature = str_replace("{PATH}",$path,$signature);
        $signature = hash_hmac($this->hashAlgo,$signature,$this->apiSecret);
        return $signature;
    }

    private function getPath($object) {
        $fullUrl = $object->getFullUrl();
        $path = dhGlobal::trimString(parse_url($fullUrl, PHP_URL_PATH),"/");
        if($this->withLeadingSlash) {
            $path = "/".$path;
        }
        return $path;
    }
}