## Table of contents
* [General info](#general-info)
* [Installing](#installing)
* [Utilities Included](#utilities-included)
* * [dhGlobal](#dhglobal)
* * [dhOut](#dhout)
* * [dhLogger](#dhlogger)

## General info
dhUtils is a collection of basic utilities to make development easier.
	
## Installing
```
composer require dhayesed/dhutils
```
	
## Utilities Included
This example sets up an instance of dhOut
it then adds it to dhGlobals.
Then it uses the global
```
//standard composer incldue:
require_once "vendor/autoload.php";

//use statements to shortcut class names -- not required but is handy.
//instead, you could use the full qualified class name
//eg, instead of dhGlobal it would be \boru\dhutils\dhGlobal (or dhOut, or dhLogger, etc)
use boru\dhutils\{dhGlobal,dhOut,dhLogger};

//create an instance of dhOut
$dhOut = new dhOut();
//add it to dhGlobal
dhGlobal::add("out",$dhOut);
//add another variable
dhGlobal::add("foo","bar");

//in some other piece of code somewhere:
dhGlobal::add("logger",new dhLogger("debug",false,$dhOut));

//And in another class/function:
dhGlobal::get("out")->add("testing dhOut from another class");
dhGlobal::get("out")->add("global var 'foo'=" . dhGlobal::get("bar"));
dhGlobal::get("logger")->debug("debug notice here");
```

### dhGlobal
Easily transport objects and variables across functions/classes without having to inject or initiate in each location
Methods:
* setup(bool stdOut, bool prefix, bool outFile, bool logFile)
* * Shortcut to set up dhGlobal::get("out") and dhGlobal::get("logger")
* add(string KEY, mixed ITEM);
* get(string KEY, mixed DEFAULT);
* isset(string KEY);
* remove(string KEY);

### dhOut

### dhLogger