<?php
namespace boru\dhutils\async;

use boru\dhutils\dhGlobal;
use React\Promise\Deferred;

class WorkGroup {
    private $name;

    /** @var Deferred */
    private $deferred;
    /** @var Work[] */
    private $work = [];
    private $pending = [];

    public function __construct($name) {
        $this->name = $name;
        $this->deferred = new Deferred();
    }

    public function deferred() {
        
        return $this->deferred;
    }
    public function promise() {
        return $this->deferred->promise();
    }

    public function addWork(Work &$work) {
        $workId = $work->getId();
        $this->work[$workId] = &$work;
        $this->pending[$workId] = null;
        $work->then(function() use ($workId) {
            $this->workDone($workId);
        },function() use ($workId) {
            $this->workDone($workId);
        });
    }
    public function workDone($workId) {
        unset($this->pending[$workId]);
        if(empty($this->pending)) {
            $this->deferred->resolve($this->name);
        }
        
    }
    public function getWork() {
        return $this->work;
    }
    public function getPending() {
        return $this->pending;
    }
    public function getName() {
        return $this->name;
    }
    public function then($success=null,$error=null) {
        $this->promise()->then($success,$error);
        return $this;
    }
}