<?php
namespace boru\dhutils\base;

use boru\dhutils\dhGlobal;

class SimpleContainer implements \JsonSerializable {
    private $data = [];

    public function __construct($data=[]) {
        if(!empty($data)) {
            $this->setFromArray($data);
        }
    }

    public function has($dotKey) {
        $val = $this->get($dotKey,"_|xzx|_NOT_SET_|xzx|_");
        return $val !== "_|xzx|_NOT_SET_|xzx|_";
    }
    public function get($key=null,$defaultValue=null) {
        if(is_null($key)) {
            return $this->toArray(false);
        }
        if(strpos($key,".") !== false) {
            return $this->dotGet($key,$defaultValue);
        }
        if(isset($this->data[$key])) {
            return $this->data[$key];
        }
        return $defaultValue;
    }
    public function dotGet($dotKey,$defaultValue=null) {
        $parts = explode(".",$dotKey);
        $current = $this->data;
        foreach($parts as $part) {
            if(!isset($current[$part])) {
                return $defaultValue;
            }
            $current = $current[$part];
        }
        return $current;
    }
    public function set($key,$value=null) {
        if(is_array($key)) {
            $this->data=$key;
            return $this;
        }
        $this->data[$key] = $value;
        return $this;
    }
    public function dotSet($dotKey,$value) {
        $parts = explode(".",$dotKey);
        $current = &$this->data;
        foreach($parts as $part) {
            if(!isset($current[$part])) {
                $current[$part] = [];
            }
            $current = &$current[$part];
        }
        $current = $value;
        return $this;
    }


    public function toArray() {
        return $this->data;
    }
    public function toJson() {
        return json_encode($this->toArray(),JSON_PRETTY_PRINT);
    }

    public function __toString() {
        return $this->toJson();
    }
    public function jsonSerialize() {
        return $this->toArray();
    }
    public function setFromArray($array) {
        if(is_object($array) && method_exists($array,"toArray")) {
            $array = $array->toArray();
        }
        if(empty($array)) { return false; }
        foreach($array as $key=>$value) {
            //add it to our data set
            $this->set($key,$value,false);
        }
    }
}