<?php
namespace boru\dhutils\base;

use boru\dhutils\dhGlobal;

/**
 * Provides a basic object with ->set() and ->get() handler
 */
class dhObject implements \JsonSerializable {
    protected $data = null;
    protected $separator = ".";

    public function __construct($arr=null,$separator=".") {
        $this->setSeparator($separator);
        if(is_array($arr) && !empty($arr)) {
            foreach($arr as $k=>$v) {
                $this->set($k,$v);
            }
        }
    }
    public function set($key,$val="",$append=false) {
        $this->setArray($this->data,$key,$val,$append);
        return $this;
    }
    public function get($key=null,$default=null) {
        return $this->getArray($this->data,$key,$default);
    }
    public function remove($key) {
        dhGlobal::dotDelete($this->data,$key,$this->separator);
        return $this;
    }
    
    public function setArray(&$array,$key,$val="",$append=false) {
        if(strpos($key,$this->separator) !== false) {
            if($append) {
                $check = dhGlobal::getDot($array,$key,$this->separator);
                if(!is_null($check)) {
                    if(is_array($check)) {
                        $check[] = $val;
                        $val = $check;
                    } else {
                        $narr = [];
                        $narr[] = $check;
                        $narr[] = $val;
                        $val = $narr;
                    }
                }
            }
            dhGlobal::dotAssign($array,$key,$val);
        }
        else {
            if(isset($array[$key]) && $append) {
                if(is_array($array[$key])) {
                    $array[$key][] = $val;
                } else {
                    $temp = $array[$key];
                    $array[$key] = [];
                    $array[$key][] = $temp;
                    $array[$key][] = $val;
                }
            } else {
                $array[$key] = $val;
            }
        }
        return $this;
    }
    
    public function getArray($array,$key=null,$default=null) {
        if(is_null($key)) {
            return !empty($array) ? $array : $default;
        }
        if(strpos($key,$this->separator) !== false) {
            $check = dhGlobal::getDot($array,$key,null,$this->separator);
            if(!is_null($check)) {
                return $check;
            }
        }
        return isset($array[$key]) ? $array[$key] : $default;
    }

    public function jsonSerialize($array=null) {
        if(is_null($array)) {
            $array = $this->data;
        }
        return $array;
    }

    /**
     * Get the value of dotSeparator
     */ 
    public function getSeparator()
    {
        return $this->separator;
    }

    /**
     * Set the value of dotSeparator
     *
     * @return  self
     */ 
    public function setSeparator($separator)
    {
        $this->separator = $separator;

        return $this;
    }
}