<?php
namespace boru\dhutils;

use \boru\dhutils\dhGlobal;
use \boru\dhutils\httplite\client\Params;
use \boru\dhutils\httplite\client\Request;
class dhHttpLite {
    protected $authType;
    protected $auth = [];
    public function __construct($auth=null) {
        if(!is_null($auth)) {
            $this->setAuth($auth);
        }
    }

    public function newHeaders() {
        return new Params("header");
    }
    public function newParams($type="array") {
        return new Params($type);
    }
    public static function params($array,$format="form") {
        return Params::fromArray($array,$format);
    }

    public function get($url,$params=null,$headers=null,$verbose=false) {
        return $this->call("get",$url,$params,$headers,$verbose);
    }
    public function post($url,$params=null,$headers=null,$verbose=false) {
        return $this->call("post",$url,$params,$headers,$verbose);
    }
    public function put($url,$params=null,$headers=null,$verbose=false) {
        return $this->call("put",$url,$params,$headers,$verbose);
    }
    public function delete($url,$params=null,$headers=null,$verbose=false) {
        return $this->call("delete",$url,$params,$headers,$verbose);
    }
    public function options($url,$params=null,$headers=null,$verbose=false) {
        return $this->call("options",$url,$params,$headers,$verbose);
    }

    public function call($method,$url,$params=null,$headers=null,$verbose=false) {
        $request = new Request();
        $request
            ->method($method)
            ->url($url);
        if(!is_null($params)) {
            $request->param($params);
        }
        if(!is_null($headers)) {
            $request->header($headers);
        }
        if(!empty($this->auth)) {
            $args = [];
            $args = $this->auth;
            array_unshift($args,$this->authType);
            $request->auth(...$args);
        }
        $request->verbose($verbose);
        return $request->call();
    }

    /**
     * Get the value of auth
     */ 
    public function getAuth()
    {
        return $this->auth;
    }

    /**
     * Set the value of auth
     *
     * @return  self
     */ 
    public function setAuth($type="Basic",...$params)
    {
        $this->authType = $type;
        $this->auth = $params;
        return $this;
    }
}