<?php
namespace boru\dhutils;

use boru\dhutils\dhGlobal;
use boru\dhutils\traits\GetSetArray;

class dhRequest {

    protected $method;

    protected $data = [
        "uri"=>[
            "scheme"=>"",
            "host"=>"",
            //"port"=>80,
            "path"=>"",
            "query"=>""
        ],
        "get"=>[],
        "post"=>[],
        "body"=>[],
        "server"=>[],
        "headers"=>[]
    ];

    use GetSetArray;

    public function __construct($get=[],$post=[],$headers=[]) {
        $this->setGet($get);
        $this->setPost($post);
        $this->setHeaders($headers);
    }
    public static function fromGlobals($jsonBody=false) {

        $instance = new self($_GET,$_POST,apache_request_headers());
        $body = file_get_contents("php://input");
        if(!empty($body)) {
            $instance->setBody($body,$jsonBody);
        }
        $instance->setServer($_SERVER);
        return $instance;
    }

    public function getGet($key=null,$default=null) {
        if(is_null($key)) {
            return $this->get("get",$default);
        }
        return $this->get("get.".$key,$default);
    }
    public function getPost($key=null,$default=null) {
        if(is_null($key)) {
            return $this->get("post",$default);
        }
        return $this->get("post.".$key,$default);
    }
    public function getBody($key=null,$default=null) {
        if(is_null($key)) {
            return $this->get("body",$default);
        }
        return $this->get("body.".$key,$default);
    }
    public function getHeader($key=null,$default=null) {
        if(is_null($key)) {
            return $this->get("headers");
        }
        return $this->get("headers.".$key,$default);
    }
    public function getServer($key=null,$default=null) {
        if(is_null($key)) {
            return $this->get("server",$default);
        }
        return $this->get("server.".$key,$default);
    }

    public function setGet($get) {
        $this->set("get",$get);
        return $this;
    }
    public function setPost($post) {
        $this->set("post",$post);
        return $this;
    }
    public function setBody($body,$json=false) {
        if($json) {
            $tempobj=json_decode($body,true);
            if(!empty($tempobj) && is_array($tempobj)) {
                foreach($tempobj as $k=>$v) {
                    $body[$k]=$v;
                }
            }
        }
        if(is_array($body)) {
            $body = dhGlobal::parseDots($body);
        }
        $this->set("body",$body);
        return $this;
    }
    public function getHeaders() {
        return $this->get("headers");
    }
    public function setHeaders($headers) {
        $this->set("headers",$headers);
        return $this;
    }
    public function setServer($server) {
        $method = isset($server['REQUEST_METHOD']) ? $server['REQUEST_METHOD'] : 'GET';
        $this->setMethod($method);
        $this->set("uri.scheme",isset($server["HTTPS"]) ? "https" : "http");
        $hasPort = false;
        if (isset($server['HTTP_HOST'])) {
            list($host, $port) = self::extractHostAndPortFromAuthority($server['HTTP_HOST']);
            if ($host !== null) {
                $this->set("uri.host",$host);
            }

            if ($port !== null) {
                $hasPort = true;
                $this->set("uri.port",$port);
            }
        } elseif (isset($server['SERVER_NAME'])) {
            $this->set("uri.host",$server['SERVER_NAME']);
        } elseif (isset($server['SERVER_ADDR'])) {
            $this->set("uri.host",$server['SERVER_ADDR']);
        }
        if (!$hasPort && isset($server['SERVER_PORT'])) {
            $this->set("uri.port",$server['SERVER_PORT']);
        }
        $hasQuery = false;
        if (isset($server['REQUEST_URI'])) {
            $requestUriParts = explode('?', $server['REQUEST_URI'], 2);
            $this->set("uri.path",$requestUriParts[0]);
            if (isset($requestUriParts[1])) {
                $hasQuery = true;
                $this->set("uri.query",$requestUriParts[1]);
            }
        }

        if (!$hasQuery && isset($server['QUERY_STRING'])) {
            $this->set("uri.query",$server['QUERY_STRING']);
        }

        $this->set("server",$server);
        return $this;
    }
    public function setUri($uri=[]) {
        $this->set("uri",$uri);
    }

    private static function extractHostAndPortFromAuthority($authority)
    {
        $uri = 'http://' . $authority;
        $parts = parse_url($uri);
        if (false === $parts) {
            return [null, null];
        }

        $host = isset($parts['host']) ? $parts['host'] : null;
        $port = isset($parts['port']) ? $parts['port'] : null;

        return [$host, $port];
    }

    /**
     * Get the value of method
     *
     * @return  mixed
     */
    public function getMethod() {
        return $this->method;
    }

    /**
     * Set the value of method
     *
     * @param   mixed  $method  
     * @return  self
     */
    public function setMethod($method) {
        $this->method = $method;
        return $this;
    }
}