<?php
namespace boru\dhutils\http;

use boru\dhutils\dAsyncHttp;
use boru\dhutils\dhGlobal;
use InvalidArgumentException;
use Exception;
use Throwable;
use UnexpectedValueException;

class Client {
    protected $headers = [];
    protected $body;
    protected $url;
    protected $onSuccess;
    protected $onError;
    protected $async=false;

    private $timeout = null;
    private $responseMaxSize = null;

    public function __construct($options=[]) {
        if(($headers = dhGlobal::getVal($options,"headers",false)) !== false) {
            $this->headers = $headers;
        }
        if(($body = dhGlobal::getVal($options,"body",false)) !== false) {
            $this->body = $body;
        }
        if(($onSuccess = dhGlobal::getVal($options,"onSuccess",false)) !== false) {
            $this->onSuccess = $onSuccess;
        } elseif(($onSuccess = dhGlobal::getVal($options,"success",false)) !== false) {
            $this->onSuccess = $onSuccess;
        }
        if(($onError = dhGlobal::getVal($options,"onError",false)) !== false) {
            $this->onError = $onError;
        } elseif(($onError = dhGlobal::getVal($options,"error",false)) !== false) {
            $this->onError = $onError;
        }
        if(($async = dhGlobal::getVal($options,"async",null)) !== null) {
            $this->async = $async ? true : false;
        }
        if(($timeout = dhGlobal::getVal($options,"timeout",false)) !== false) {
            $this->timeout = $timeout;
        }
        if(($responseMaxSize = dhGlobal::getVal($options,"responseMaxSize",false)) !== false) {
            $this->responseMaxSize = $responseMaxSize;
        }
    }
    public function timeout($timeout=null) {
        $this->timeout = $timeout;
        return $this;
    }
    public function async($async=true) {
        $this->async = $async;
        return $this;
    }
    public function synchronous($sync=true) {
        $this->async(!$sync);
        return $this;
    }

    public function header($headerName,$headerValue=null) {
        $this->headers[$headerName] = $headerValue;
        return $this;
    }
    public function body($keyPath,$value=null,$separator=".") {
        dhGlobal::dotAssign($this->body,$keyPath,$value,$separator);
        return $this;
    }
    public function bodyFromData($data) {
        if(!is_array($data)) {
            $check = json_decode($data,true);
            if(is_array($check)) {
                $data = $check;
            }
        }
        if(is_array($data)) {
            foreach($data as $k=>$v) {
                $this->body($k,$v);
            }
        } else {
            $this->body = $data;
        }
    }

    public function json($data=null) {
        $this->header('Content-Type','application/json');
        if(!is_null($data)) {
            $this->bodyFromData($data);
        }
        return $this;
    }
    public function form($data) {
        $this->header('Content-Type','application/x-www-form-urlencoded');
        if(!is_null($data)) {
            $this->bodyFromData($data);
        }
        return $this;
    }
    public function raw($data) {
        $this->body = $data;
        return $this;
    }

    public function url($url) {
        $this->url = $url;
        return $this;
    }
    public function get($url=null) {
        if(!is_null($url)) {
            $this->url($url);
        }
        return $this->send("get");
    }
    public function post($url=null) {
        if(!is_null($url)) {
            $this->url($url);
        }
        return $this->send("post");
    }
    public function put($url=null) {
        if(!is_null($url)) {
            $this->url($url);
        }
        return $this->send("put");
    }
    public function patch($url=null) {
        if(!is_null($url)) {
            $this->url($url);
        }
        return $this->send("patch");
    }
    public function delete($url=null) {
        if(!is_null($url)) {
            $this->url($url);
        }
        return $this->send("delete");
    }
    public function head($url=null) {
        if(!is_null($url)) {
            $this->url($url);
        }
        return $this->send("head");
    }
    /**
     * 
     * @param mixed $method 
     * @return \React\Promise\ExtendedPromiseInterface
     * @throws InvalidArgumentException 
     * @throws Exception 
     * @throws Throwable 
     * @throws UnexpectedValueException 
     */
    public function send($method) {
        $method = strtolower($method);
        if(is_null($this->body)) {
            $this->body = "";
        }
        if($method == "get") {
            $promise = dAsyncHttp::get($this->url,$this->headers,$this->onSuccess,$this->onError,$this->timeout);
        } elseif($method == "post") {
            $promise = dAsyncHttp::post($this->url,$this->headers,$this->body,$this->onSuccess,$this->onError,$this->timeout);
        } elseif($method == "put") {
            $promise = dAsyncHttp::put($this->url,$this->headers,$this->body,$this->onSuccess,$this->onError,$this->timeout);
        } elseif($method == "patch") {
            $promise = dAsyncHttp::patch($this->url,$this->headers,$this->body,$this->onSuccess,$this->onError,$this->timeout);
        } elseif($method == "delete") {
            $promise = dAsyncHttp::delete($this->url,$this->headers,$this->body,$this->onSuccess,$this->onError,$this->timeout);
        } elseif($method == "head") {
            $promise = dAsyncHttp::head($this->url,$this->headers,$this->onSuccess,$this->onError,$this->timeout);
        }
        return $promise;
    }

    public function toArray() {
        return [
            "url"=>$this->url,
            "headers"=>$this->headers,
            "body"=>$this->body,
            "timeout"=>$this->timeout
        ];
    }
}