<?php
namespace boru\dhutils\httplite\client;

use \boru\dhutils\dhGlobal;
use \boru\dhutils\httplite\client\Params;

class Response {
    protected $code;
    protected $version;
    protected $codeMessage;
    protected $headers;
    protected $body;
    protected $jsonObject;
    protected $jsonArray;
    protected $execTime;

    protected $isError=false;
    protected $errorCode;
    protected $errorMessage;
    public function __construct($code=200,$headers=null,$body=null,$execTime=null) {
        $this->setCode($code);
        $this->headers = new Params("array");
        if(!is_null($headers)) {
            $this->setHeaders($headers);
        }
        if(!is_null($body)) {
            $this->setBody($body);
        }
        $extra = "";
        if(!is_null($execTime)) {
            $this->setExecTime($execTime);
            $extra = "after ".round($execTime,3)."s ";
        }
        
        dhGlobal::log("info","dhHttp response created ".$extra."with status code ".$code);
    }
    public function get($json=false) {
        $o = $this->getInfo(true);
        if($json) {
            $o["json"] = $this->getJson();
        }
        if(!$json || !isset($o["json"]) || is_null($o["json"])) {
            $o["body"] = $this->getBody();
        }
        return $o;
    }
    public function getInfo($headers=false) {
        $o = [
            "code"=>$this->getCode(),
            "codeMessage"=>$this->getCodeMessage(),
            "version"=>$this->getVersion(),
            "execTime"=>$this->getExecTime()
        ];
        if($headers) {
            $o["headers"] = $this->getHeaders();
        }
        return $o;
    }
    public function getVersion() {
        return !is_null($this->version) ? $this->version : false;
    }
    public function getCode() {
        return !is_null($this->code) ? $this->code : false;
    }
    public function getCodeMessage() {
        return !is_null($this->codeMessage) ? $this->codeMessage : false;
    }
    public function getExecTime() {
        return !is_null($this->execTime) ? $this->execTime : false;
    }
    public function getHeaders($header=null) {
        $array = $this->headers->get();
        if(empty($header) || is_null($header)) {
            return $array;
        }
        return isset($array[$header]) ? $array[$header] : null;
    }
    public function getBody() {
        return $this->body;
    }
    public function getJson($item=null,$default=null) {
        if(is_null($this->jsonArray)) {
            $try = json_decode($this->body,true);
            if(is_array($try) || is_object($try)) {
                $this->jsonArray = $try;
            }
        }
        if(empty($item) || is_null($item)) {
            return $this->jsonArray;
        }
        if(strpos($item,".") !== false) {
            $check = dhGlobal::getDot($this->jsonArray,$item);
            if(!is_null($check)) {
                return $check;
            }
        }
        return isset($this->jsonArray[$item]) ? $this->jsonArray[$item] : $default;
    }
    public function getJsonObject() {
        if(is_null($this->jsonObject)) {
            $try = json_decode($this->body);
            if(is_object($try)) {
                $this->jsonObject = $try;
            }
        }
        return $this->jsonObject;
    }
    public function setHeaders($headers) {
        $harr = explode("\n",$headers);
        if(strpos($harr[0],":") === false && strpos($harr[0],"HTTP") !== false) {
            $t = explode(" ",$harr[0],3);
            $this->version = $t[0];
            $this->codeMessage = $t[2];
            $this->headers->set("@",$harr[0]);
            array_shift($harr);
        }
        foreach($harr as $header) {
            $temp = explode(": ",trim($header));
            $v = isset($temp[1]) ? $temp[1] : "";
            $this->headers->set($temp[0],$v);
        }
    }
    public function setBody($body) {
        $this->body = $body;
    }
    public function setExecTime($time) {
        $this->execTime = $time;
    }

    /**
     * Set the value of code
     *
     * @return  self
     */ 
    public function setCode($code)
    {
        $this->code = $code;

        return $this;
    }
    

    /**
     * Get the value of isError
     */ 
    public function isError()
    {
        return $this->isError;
    }

    /**
     * Set the value of isError
     *
     * @return  self
     */ 
    public function setIsError($isError)
    {
        $this->isError = $isError;

        return $this;
    }

    /**
     * Get the value of errorCode
     */ 
    public function getErrorCode()
    {
        return $this->errorCode;
    }

    /**
     * Set the value of errorCode
     *
     * @return  self
     */ 
    public function setErrorCode($errorCode)
    {
        $this->errorCode = $errorCode;

        return $this;
    }

    /**
     * Get the value of errorMessage
     */ 
    public function getErrorMessage()
    {
        return $this->errorMessage;
    }

    /**
     * Set the value of errorMessage
     *
     * @return  self
     */ 
    public function setErrorMessage($errorMessage)
    {
        $this->errorMessage = $errorMessage;

        return $this;
    }
}