<?php
namespace boru\dhutils\loader;

use boru\dhutils\dhGlobal;
use boru\dhutils\dhLoader;
/**
 * psr-4 autoloader implementation for dhLoader
 */
class PSR4 {
    protected $classMap = [];
    protected $extension = "php";
    public function init() {
        spl_autoload_register([$this,"autoload"]);
    }
    public function autoload($className) {
        //dhGlobal::debug("Autoload attempt");

        $map = "";
        if(($map = $this->getClassMap($className)) === false) {
            //Class is not within our defined map, move on to the next autoloader (if any)
            return;
        }
        $basePath = $map["path"];
        $prefix = $map["prefix"];

        // get the relative class name
        $relative_class = substr($className, strlen($prefix));

        // replace the namespace prefix with the base directory, replace namespace
        // separators with directory separators in the relative class name, append
        // with .php
        $file = $basePath.str_replace('\\', '/', $relative_class);
        //dhGlobal::debug("Autoload attempt",$file);
        // if the file exists, require it
        if (file_exists($file.".".$this->extension)) {
            return dhLoader::includeOnce($file,$this->extension);
        }
        return;
    }
    public function add($prefix="some\\prefix\\",$path=".") {
        if(substr($path,strlen(DIRECTORY_SEPARATOR)) != DIRECTORY_SEPARATOR) {
            $path.=DIRECTORY_SEPARATOR;
        }
        $this->classMap[$prefix] = $path;
    }
    public function getClassMap($className) {
        foreach($this->classMap as $prefix => $path) {
            //dhGlobal::debug("checking",$prefix,$path);
            if (strncmp($prefix, $className, strlen($prefix)) === 0) {
                return ["prefix"=>$prefix,"path"=>$path];
            }
        }
        return false;
    }
}