<?php
namespace boru\dhutils\loader;

use boru\dhutils\dhGlobal;
use boru\dhutils\dhLoader;

/**
 * Used to bootstrap an app-autoloader. Auto-loads the following:
 * * Type -> types/Type.php
 * * Class_Type -> types/Class.php
 * * Subtype_Class_Type -> types/subtypes/Class.php
 * * Subtype_Subtype1_Class_Type -> types/subtypes/subtype1s/Class.php
 * * Subtype_Subtype1_Subtype2_Class_Type -> types/subtypes/subtype1s/subtype2s/Class.php
 */
class TypeClass {
    /**
     * Only attempts to autoLoad if the className begins with this prefix. Default is blank (all classes)
     * 
     * Useful if adding this loader on top of other loaders that you don't want to interfere with.
     */
    protected $classPrefix = "";
    public $debug = false;

    public function init() {
        spl_autoload_register([$this,"autoload"]);
    }
    

    /**
     * Directories are all lowercase, Classe
     * * Type -> types/Type.php
     * * Class_Type -> types/Class.php
     * * Subtype_Class_Type -> types/subtypes/Class.php
     * * Subtype_Subtype1_Class_Type -> types/subtypes/subtype1s/Class.php
     * * Subtype_Subtype1_Subtype2_Class_Type -> types/subtypes/subtype1s/subtype2s/Class.php
     */
    public function autoload($className) {
		//Ipad_Index_View
		//Ipad_Users_Login_Action
        $parts = explode('_', $className);
        $prefix = $this->classPrefix();
        if(!empty($prefix)) {
            $first = array_shift($parts);
            if($first !== $prefix || empty($parts)) {
                return false;
            }
        }

        $classParts = [];
        $type = array_pop($parts);
        if(empty($parts)) {
            //Type -> types/Type.php
            $classParts = [strtolower($type)."s",$type];
        } else {
            $class = array_pop($parts);
            if(empty($parts)) {
                //Class_Type -> types/Class.php
                $classParts = [strtolower($type)."s",$class];
            } else {
                $classParts = [$class];
                while(!empty($parts)) {
                    array_unshift($classParts,strtolower(array_pop($parts))."s");
                }
                array_unshift($classParts,strtolower($type)."s");
            }
        }
        if($this->debug) {
            dhGlobal::debug("Autoload attempt",$classParts);
        }
		return dhLoader::includeOnce(implode(".",$classParts));
	}
    
    public function classPrefix(string $prefix=null)
    {
        if(is_null($prefix)) {
            return $this->classPrefix;
        } else {
            $this->classPrefix = $prefix;
        }
    }
}