<?php
namespace boru\dhutils\mail;

class Imap {
    public $validateConfig = ["overall"=>false,"valid"=>[],"invalid"=>[]];
    
    protected $mailConfig = [
        "host"=>"",
        "port"=>0,
        "user"=>"",
        "pass"=>"",
        "options"=>["imap","ssl"],
        "mailbox"=>"INBOX",
        "attachmentsDir"=>null,
        "extra"=>[
            "doCount"=>false
        ]
    ];
    protected $mailbox;
    
    public function __construct($mailConfig=[]) {
        if(!empty($mailConfig)) {
            $this->config($mailConfig);
        }
    }

    public function setConfig($item,$value) {
        if(isset($this->mailConfig[$item])) {
            $this->mailConfig[$item] = $value;
        } else {
            $this->mailConfig["extra"][$item] = $value;
        }
    }
    public function getConfig($item,$default=null) {

    }
    public function config($mailConfig) {
        foreach($this->mailConfig as $cfg=>$v) {
            if(isset($mailConfig[$cfg])) {
                $this->mailConfig[$cfg] = $mailConfig[$cfg];
                unset($mailConfig[$cfg]);
            }
        }
        if(!empty($mailConfig)) {
            $this->mailConfig["extra"] = $mailConfig;
        }
        $v = $this->validateConfig();
    }

    public function getMailbox($connString,$user,$pass,$attachmentsDir=null,$encoding="UTF-8") {
       return new \PhpImap\Mailbox($connString, $user, $pass, $attachmentsDir,$encoding);
    }

    protected function validateConfig($cfg = []) {
        if(empty($cfg)) {
            $cfg = $this->mailConfig;
        }
        $valid = [
            "host"=>false,
            "port"=>false,
            "user"=>false,
            "pass"=>false,
            "mailbox"=>false
        ];
        foreach($valid as $name=>$false) {

            if(!empty($this->mailConfig[$name])) {
                $valid[$name] = true;
            }
        }
        $invalid = [];
        $overall = true;
        foreach($valid as $k=>$v) {
            if(!$v) {
                $overall=false;
                $invalid[$k]=true;
                unset($valid[$k]);
            }
        }
        $this->validateConfig = ["overall"=>$overall,"valid"=>$valid,"invalid"=>$invalid];
        return $overall;
    }
}