<?php
namespace boru\dhutils\mail;

use \boru\dhutils\dhGlobal;
use \PHPMailer\PHPMailer\PHPMailer;

class SMTP {
    protected $mailConfig = [
        "host"=>"",
        "port"=>0,
        "user"=>"",
        "pass"=>"",
        "auth"=>true,
        "secure"=>false,
        "extra"=>[]
    ];
    protected PHPMailer $client;
    protected $isConfiged = false;

    public function __construct($mailConfig=[]) {
        if(!empty($mailConfig)) {
            $this->config($mailConfig);
        }
        $this->client = new PHPMailer(true);
    }
    public function config($mailConfig) {
        foreach($this->mailConfig as $cfg=>$v) {
            if(isset($mailConfig[$cfg])) {
                $this->mailConfig[$cfg] = $mailConfig[$cfg];
                unset($mailConfig[$cfg]);
            }
        }
        if(!empty($mailConfig)) {
            $this->mailConfig["extra"] = $mailConfig;
        }

        $this->client->Host         = $this->mailConfig["host"];
        $this->client->Port         = $this->mailConfig["port"];
        $this->client->SMTPAuth     = $this->mailConfig["auth"];
        $this->client->Username     = $this->mailConfig["user"];
        $this->client->SMTPSecure   = $this->mailConfig["secure"];
        $this->isConfiged = true;
    }

    public function output($success=true,$code=0,$message=null) {
        return ["success"=>$success,"code"=>$code,"message"=>$message];
    }
    public function send() {
        if(!$this->isConfiged) {
            return $this->output(false,-100,"Must configure before sending");
        }
        $success=false;
        $code=-1;
        $message=null;
        try {
            $this->client->send();
            $success=true;
            $code=0;
        } catch (\Exception $e) {
            $message = $e->getMessage();
            $code = $e->getCode();
        }
        return $this->output($success,$code,$message);
    }

    public function __call($method, $args) {
        if(!method_Exists($this->client, $method)) {
            throw new \Exception("Method $method does not exist on PHPMailer object",-1);
        }
        call_user_func_array(array($this->client, $method), $args);
    }
}