<?php
namespace boru\dhutils\multithread\parts;

use boru\dhutils\dhGlobal;
use boru\dhutils\traits\GetSetArray;

class WorkResult {
    private $success;
    private $workId;
    private $data;
    private $stdout;
    private $code;
    private $message;
    private $trace;

    public function __construct($data=null) {
        if(!is_null($data)) {
            if(!is_array($data) && !is_object($data)) {
                $data = json_decode($data,true);
            }
            if(is_array($data)) {
                $this->success  = dhGlobal::getVal($data,"success",false);
                $this->success  = dhGlobal::getVal($data,"data.workId",false);
                $this->data     = dhGlobal::getVal($data,"data.data",null);
                $this->stdout   = dhGlobal::getVal($data,"data.stdout",null);
                $this->code     = dhGlobal::getVal($data,"data.code",null);
                $this->message  = dhGlobal::getVal($data,"data.message",null);
                $this->trace  = dhGlobal::getVal($data,"data.trace",null);
            }
        }
    }

    public static function fromFrame(WorkerFrame $frame) {
        $instance = new self($frame->get());
        return $instance;
    }
    public static function fromJson($jsonData) {
        $instance = new self($jsonData);
        return $instance;
    }
    public static function fromArray($arrayData) {
        $instance = new self($arrayData);
        return $instance;
    }

    public function success() {
        return $this->getSuccess();
    }
    public function data($keyString=null,$default=null) {
        if(is_null($keyString)) {
            return $this->getData();
        } else {
            if(is_array($this->data)) {
                return dhGlobal::getVal($this->data,$keyString,$default);
            }
            return $default;
        }
    }
    public function stdout() {
        return $this->getStdout();
    }
    public function code() {
        return $this->getCode();
    }
    public function message() {
        return $this->getMessage();
    }
    public function trace() {
        return $this->getTrace();
    }
    public function error() {
        return ["success"=>$this->success(),"error"=>!$this->success(),"code"=>$this->code(),"message"=>$this->message(),"trace"=>$this->trace()];
    }
    

    /**
     * Get the value of success
     *
     * @return  mixed
     */
    public function getSuccess() {
        return $this->success;
    }

    /**
     * Set the value of success
     *
     * @param   mixed  $success  
     * @return  self
     */
    public function setSuccess($success) {
        $this->success = $success;
        return $this;
    }

    /**
     * Get the value of data
     *
     * @return  mixed
     */
    public function getData() {
        return $this->data;
    }

    /**
     * Set the value of data
     *
     * @param   mixed  $data  
     * @return  self
     */
    public function setData($data) {
        $this->data = $data;
        return $this;
    }

    /**
     * Get the value of stdout
     *
     * @return  mixed
     */
    public function getStdout() {
        return $this->stdout;
    }

    /**
     * Set the value of stdout
     *
     * @param   mixed  $stdout  
     * @return  self
     */
    public function setStdout($stdout) {
        $this->stdout = $stdout;
        return $this;
    }

    /**
     * Get the value of code
     *
     * @return  mixed
     */
    public function getCode() {
        return $this->code;
    }

    /**
     * Set the value of code
     *
     * @param   mixed  $code  
     * @return  self
     */
    public function setCode($code) {
        $this->code = $code;
        return $this;
    }

    /**
     * Get the value of message
     *
     * @return  mixed
     */
    public function getMessage() {
        return $this->message;
    }

    /**
     * Set the value of message
     *
     * @param   mixed  $message  
     * @return  self
     */
    public function setMessage($message) {
        $this->message = $message;
        return $this;
    }

    /**
     * Get the value of trace
     *
     * @return  mixed
     */
    public function getTrace() {
        return $this->trace;
    }

    /**
     * Set the value of trace
     *
     * @param   mixed  $trace  
     * @return  self
     */
    public function setTrace($trace) {
        $this->trace = $trace;
        return $this;
    }

    /**
     * Get the value of trace
     *
     * @return  mixed
     */
    public function getWorkId() {
        return $this->workId;
    }

    /**
     * Set the value of workId
     *
     * @param   mixed  $workId  
     * @return  self
     */
    public function setWorkId($workId) {
        $this->workId = $workId;
        return $this;
    }
}