<?php
namespace boru\dhutils\multithread\parts;

use boru\dhutils\traits\GetSetArray;

class WorkerFrame {

    const E_FRAME_ERROR = "frame_error";
    const E_UNKNOWN_FRAME = "unknown_frame";
    const E_NOT_CALLABLE = "not_callable";
    const E_EXECUTE_EXCEPTION = "execute_exception";
    const E_BOOSTRAPPED_ALREADY = "bootstrapped_already";
    const E_BOOTSTRAP_INVALID = "bootstrap_invalid";
    const E_BOOTSTRAP_NOT_FOUND = "bootstrap_not_found";
    const E_BOOTSTRAP_NOT_CALLABLE = "boostrap_not_callable";

    use GetSetArray;
    
    private $startDelimiter = "#";
    private $endDelimiter = "#";
    private $typeDelimiter = "$";

    protected $packet;
    protected $type;
    protected $rawData;
    protected $encodedData;
    protected $data;
    protected $valid = false;

    public function __construct() {
        
    }

    private $lastError;

    public function encode($data=[]) {
        if(!empty($data)) {
            $this->data = $data;
        }
        $this->rawData = json_encode($this->data);

        if(is_null($this->type)) {
            $this->type="base64";
        }
        
        if(($this->encodedData = $this->encodeType($this->type,$this->rawData)) === false) {
            $this->lastError = "unknown_frame_type";
            return false;
        }
        $this->createFrame();
        return true;
    }
    public function decode($rawPacket) {
        $this->valid = false;

        $this->packet = $rawPacket;
        if(($parsedFrame = $this->parseFrame()) !== false) {
            if(($this->rawData = $this->decodeType($parsedFrame["type"],$parsedFrame["data"])) === false) {
                $this->lastError = "unknown_frame_type";
                return false;
            }
            $this->type = $parsedFrame["type"];
            $parsed = $this->parseJson($this->rawData);
            if(is_array($parsed)) {
                $this->data = $parsed;
                $this->valid = true;
                $this->lastError = null;
            } else {
                $this->data = null;
                $this->valid = false;
                $this->lastError = "json_failure";
            }
        } else {
            $this->lastError = "malformed_frame";
            return false;
        }
    }

    private function encodeType($type,$rawData) {
        if($type == "plain") {
            return $rawData;
        } elseif($type == "base64") {
            return base64_encode($rawData);
        }
        return false;
    }
    private function decodeType($type,$encodedData) {
        if($type == "plain") {
            return $this->decodePlain($encodedData);
        } elseif($type == "base64") {
            return $this->decodeBase64($encodedData);
        }
        return false;
    }

    public function getWorkResult() {
        return new WorkResult($this->get());
    }
    public function packet() {
        return $this->getPacket();
    }
    public function type() {
        return $this->getType();
    }
    public function rawData() {
        return $this->getRawData();
    }
    public function data() {
        return $this->getData();
    }
    public function valid() {
        return $this->getValid();
    }
    public function meta() {
        return [
            "packet"=>$this->packet,
            "type"=>$this->type,
            "rawData"=>$this->rawData,
            "valid"=>$this->valid,
            "lastError"=>$this->lastError,
        ];
    }

    private function decodePlain($framedData) {
        return $framedData;
    }
    private function decodeBase64($framedData) {
        return base64_decode($framedData);
    }

    private function parseJson($data) {
        $json = json_decode($data,true);
        if(is_array($json)) {
            return $json;
        } else {
            return false;
        }
    }
    
    private function parseFrame() {
        $rawPacket = $this->packet;
        $delimStart = $this->startDelimiter;
        $delimEnd = $this->endDelimiter;
        $delimType = $this->typeDelimiter;



        if(substr($rawPacket,0,strlen($delimStart)) == $delimStart && substr($rawPacket,-strlen($delimEnd)) == $delimEnd) {
            $rawPacket = substr($rawPacket,1);
            $rawPacket = substr($rawPacket,0,-1);
            $parts = explode($delimType,$rawPacket,2);
            if(count($parts) !== 2) {
                return false;
            }
            return ["type"=>$parts[0],"data"=>$parts[1]];
        }
    }

    private function createFrame() {
        $this->packet = $this->startDelimiter.$this->type.$this->typeDelimiter.$this->encodedData.$this->endDelimiter;
        return $this->packet;
    }


    /**
     * Get the value of packet
     *
     * @return  mixed
     */
    public function getPacket() {
        if(is_null($this->packet) && !is_null($this->data)) {
            $this->encode();
        }
        return $this->packet;
    }

    /**
     * Set the value of packet
     *
     * @param   mixed  $packet  
     * @return  self
     */
    public function setPacket($packet) {
        $this->packet = $packet;
        return $this;
    }

    /**
     * Get the value of type
     *
     * @return  mixed
     */
    public function getType() {
        return $this->type;
    }

    /**
     * Set the value of type
     *
     * @param   mixed  $type  
     * @return  self
     */
    public function setType($type) {
        $this->type = $type;
        return $this;
    }

    /**
     * Get the value of rawData
     *
     * @return  mixed
     */
    public function getRawData() {
        return $this->rawData;
    }

    /**
     * Set the value of rawData
     *
     * @param   mixed  $rawData  
     * @return  self
     */
    public function setRawData($rawData) {
        $this->rawData = $rawData;
        return $this;
    }

    /**
     * Get the value of data
     *
     * @return  mixed
     */
    public function getData() {
        return $this->data;
    }

    /**
     * Set the value of data
     *
     * @param   mixed  $data  
     * @return  self
     */
    public function setData($data) {
        $this->data = $data;
        return $this;
    }

    /**
     * Get the value of valid
     *
     * @return  mixed
     */
    public function getValid() {
        return $this->valid;
    }

    public static function fromPacket($rawPacket) {
        $instance = new self();
        $instance->decode($rawPacket);
        return $instance;
    }
    public static function fromData($data=[],$type="base64") {
        $instance = new self();
        return $instance->setType($type)->setData($data);
    }
}