<?php
namespace boru\dhutils\multithread\process;

use boru\dhutils\dhGlobal;
use boru\dhutils\multithread\parts\Buffer;
use boru\dhutils\tools\ProcessQueue;
use React\Promise\Deferred;
use React\Promise\Promise;
use React\Promise\PromiseInterface;
use UnexpectedValueException;
use RuntimeException;

class ClassProcess {
    private $callable;
    private $bootstrap;
    private $args = [];

    private $json = false;
    private $jsonAsArray = true;

    /** @var Process */
    private $process;
    /** @var Deferred */
    private $deferred;

    /**
     * 
     * @param mixed $callable 
     * @param mixed $methodName 
     * @param array $args 
     * @param mixed $bootstrap 
     * @return void 
     */
    public function __construct(callable $callable,$args=[],$bootstrap=null) {
        $this->setCallable($callable);
        $this->setBootstrap($bootstrap);
        if(!empty($args)) {
            $this->setArgs($args);
        }

        $meta = [
            "onStart"=>function() {
                $this->onStart();
            },
            "onDone"=>function($exitCode=null,$termSignal=null) {
                $this->onDone($exitCode,$termSignal);
            },
        ];

        $this->process = new Process("php -f ".__DIR__."/../util/ClassMethod.php",[],$meta);
        $this->deferred = new Deferred();   
    }

    /**
     * Starts the Child Process, returns the ClassProcess Promise for easy chaining
     * 
     * @return Promise 
     * @throws UnexpectedValueException 
     * @throws RuntimeException 
     */
    public function start() {
        $this->process->start();
        return $this->Promise();
    }

    /** @return \React\Promise\Promise */
    public function Promise() {
        return $this->deferred->promise();
    }
    /** @return \boru\dhutils\multithread\process\Process */
    public function Process() {
        return $this->process;
    }

    /**
     * Wrapper for \React\Promise\Promise::then()
     * @param callable|null $onFulfilled 
     * @param callable|null $onRejected 
     * @return PromiseInterface 
     */
    public function then(callable $onFulfilled=null,callable $onRejected=null) {
        return $this->Promise()->then($onFulfilled,$onRejected);
    }


    private function makePacket() {
        return json_encode([
            "callable"=>$this->callable,
            "bootstrap"=>$this->bootstrap,
            "args"=>$this->args,
        ]);   
    }
    private function parseOutputPacket($lines) {
        $started=false;
        $data = "";
        foreach($lines as $line) {
            if($started) {
                if($line == "#END#") {
                    break;
                }
                $data.=$line."\n";
            }
            if($line == "#START#") {
                $started = true;
            }
        }
        if($this->json) {
            return json_decode($data,$this->jsonAsArray);
        }
        return $data;
    }

    private function onDone($exitCode=null,$termSignal=null) {
        $buffer = $this->process->Buffer();
        $output = $this->parseOutputPacket($buffer->readOut());
        $this->deferred->resolve($output);
    }
    private function onStart() {
        $this->process->write($this->makePacket()."\n#END#\n");
    }


    /**
     * Set the value of callable
     *
     * @param   mixed  $callable  
     * @return  self
     */
    public function setCallable(callable $callable) {
        $this->callable = $callable;
        return $this;
    }

    /**
     * Set the value of bootstrap
     *
     * @param   mixed  $bootstrap  
     * @return  self
     */
    public function setBootstrap($bootstrap) {
        $this->bootstrap = $bootstrap;
        return $this;
    }

    /**
     * Set the value of args
     *
     * @param   mixed  $args  
     * @return  self
     */
    public function setArgs($args) {
        $this->args = $args;
        return $this;
    }

    /**
     * If true, decode the output as JSON
     *
     * @param   bool  $json 
     * @param   bool  $asArray (default:true) if false, return a stdObject instead of array
     * @return  self
     */
    public function setJson($json,$asArray=true) {
        $this->json = $json;
        $this->jsonAsArray = $asArray;
        return $this;
    }
}