<?php
$pparts = explode(DIRECTORY_SEPARATOR,__DIR__);
$pparts = array_reverse($pparts);
if($pparts[2] == "dhdb" && $pparts[4] == "vendor") {
    require __DIR__."/../../../../../autoload.php";
} else {
    require __DIR__."/../../../vendor/autoload.php";
}

use boru\dhutils\dhGlobal;
use boru\dhutils\tools\ProcessQueue;

//We're doing an initial packet read to make sure we're valid.. this way the next line isn't exploitable externally.
$data = dhUtils_Multithread_ClassMethodRunner::read();
if(is_array($data)) {
    if(isset($data["bootstrap"])) {
        if(file_exists($data["bootstrap"])) {
            require $data["bootstrap"];
        }
    }
    if(isset($data["persist"]) && $data["persist"]) {
        dhUtils_Multithread_ClassMethodRunner::$persist = true;
    }
}

$result = dhUtils_Multithread_ClassMethodRunner::run($data);
if($result && dhUtils_Multithread_ClassMethodRunner::$persist) {
    while($result) {
        $data = dhUtils_Multithread_ClassMethodRunner::read();
        $result = dhUtils_Multithread_ClassMethodRunner::run($data);
    }
} elseif($result) {
    dhUtils_Multithread_ClassMethodRunner::terminate(true);
} else {
    dhUtils_Multithread_ClassMethodRunner::terminate(false);
}




class dhUtils_Multithread_ClassMethodRunner {
    public static $persist = false;
    public static function read($run=false) {
        $lines = [];
        while(($line = trim(fgets(STDIN))) != "#END#") {
            $lines[] = $line;
        }
        $packet = implode("\n",$lines);
        $data = json_decode($packet,true);
        if(!is_array($data)) {
            static::error("Malformed data packet");
        } else {
            if($run) {
                return static::run($data);
            } else {
                return $data;
            }
        }
    }
    public static function run($data) {
        $callable = isset($data["callable"]) ? $data["callable"] : false;
        $args = isset($data["args"]) ? $data["args"] : [];
        if($callable === false) {
            static::error("Must have callable");
            return false;
        } else {
            if(is_callable($callable)) {
                static::output("#START#");
                call_user_func($callable,...$args);
                static::output("#END#");
                return true;
            } else {
                static::error("Callable does not exist");
                return false;
            }
        }
    }

    public static function error($msg="") {
        static::output("#ERROR#".$msg);
        static::terminate(false);
    }
    public static function output($output) {
        echo $output."\n";
    }
    public static function terminate($success=true) {
        if(!$success) {
            exit(1);
        }
        exit();
    }
}