<?php
namespace boru\dhutils\progress;

use boru\dhutils\dhGlobal;
use boru\dhutils\tools\StdOut;
use boru\dhutils\tools\Template;

class Bar {
    private $data;
    private $barFormat = "";

    private $content = "";

    private $timeStarted;
    private $percentBar;
    private $percentBarLastPercent;

    /** @var Template */
    private $template;

    public function __construct($barFormat="") {
        $this->barFormat($barFormat);
        $this->template = new Template();
        $this->generate();
    }

    public function content() {
        $this->generate();
        return $this->content;
    }

    public function registerMethod($methodName,callable $callable) {
        $this->template->registerMethod($methodName,$callable);
    }
    public function registerModifier($modifierName,callable $callable) {
        $this->template->registerModifier($modifierName,$callable);
    }

    private function generate() {
        if(is_null($this->timeStarted)) {
            $this->timeStarted = microtime(true);
        }
        $timeElapsed = $this->timeElapsed();
        $percent = $this->get("percent",0);
        $remainingTime = $this->remainingTime($percent,$timeElapsed);
        $percentBar = $this->percentBar($percent);

        $this->data["elapsedTime"] = $timeElapsed;
        $this->data["remainingTime"] = $remainingTime;
        $this->data["percentBar"] = $percentBar;
        $this->data["memUsage"] = memory_get_usage();

        $this->content = $this->template->parse($this->barFormat,$this->data);
        
        return $this->content;
    }

    public function set($key,$val="") {
        $this->data[$key] = $val;
        $this->generate();
        return $this;
    }
    public function get($key=null,$default=null) {
        return isset($this->data[$key]) ? $this->data[$key] : $default;
    }

    public function timeElapsed() {
        if(is_null($this->timeStarted)) {
            $runTime = 0;
        } else {
            $runTime = microtime(true)-$this->timeStarted;
        }
        return $runTime;
    }
    public function remainingTime($percent=null,$elapsedTime=null) {
        if(is_null($elapsedTime)) {
            $elapsedTime = $this->timeElapsed();
        }
        if(is_null($percent) || $elapsedTime<=0 || $percent==0) {
            return "N/A";
        }
        $EC = $elapsedTime / $percent;
        $RC = 100 - $percent;
        $remainingTime = $RC * $EC;

        return $remainingTime;
    }

    private function percentBar($percent=null) {
        if(is_null($percent)) {
            $percent = 0;
        }
        if(is_null($this->percentBar) || $this->percentBarLastPercent != $percent) {
            $empty = 20;
            $string = "";
            $filled = floor($percent/5);
            if($filled>0) {
                $string.= StdOut::ansiColor("green").str_repeat("X",$filled).StdOut::ansiColor("reset");
                $empty = 20 - $filled;
            }
            if($empty>0) {
                $string.= StdOut::ansiColor("yellow").str_repeat(".",$empty).StdOut::ansiColor("reset");
            }
            $this->percentBar = " |> ".$string." <| ";
        }
        return $this->percentBar;
    }

    public function barFormat($barFormat="") {
        $this->barFormat = $barFormat;
    }
}