<?php
namespace boru\dhutils\progress;

use boru\dhutils\dhGlobal;
use boru\dhutils\tools\StatusBar;
use boru\dhutils\tools\StdOut;

class QueueStatus {
    /** @var \boru\dhutils\progress\Bar */
    private $bar;
    /** @var \boru\dhutils\tools\StatusBar */
    private $statusBar;

    private $percent = 0;
    private $remaining = 0;
    private $total = 0;
    
    private $timeStarted;

    private $threadData = [];

    private $barFormat = "{name} %{percent|pad:7} | ~{remainingTime|timeFormat|pad:8} | +{elapsedTime|timeFormat|pad:8} | {remaining} / {total} | {percentBar}";
    private $threadsAdded=false;

    public function __construct($name="Progress",$threads=null) {
        if(!is_null($threads)) {
            $this->setThreads($threads);
        }
        $this->bar = new Bar($this->barFormat);
        /*$this->bar->registerMethod("testing",function($a,$b) {
            return "Tested!";
        });
        $this->bar->registerModifier("test",function($bar,$value) {
            return $value."123";
        });*/
        $this->bar->set("name",$name);
        $this->updateBar();
        $this->statusBar = new StatusBar(0.5,$this->bar);
        $this->statusBar->addBar($name,$this->bar);
    }

    public function getBar() {
        return $this->statusBar;
    }

    public function updateThread($threadNumber,$key,$value) {
        $this->threadData[$threadNumber][$key] = $value;
        usort($this->threadData,function($a,$b) {
            if($a["display"] == "<ready>" || $a["display"] == "<done>" || $a["display"] == "<init>") {
                $at=-1;
            } else {
                $at = isset($a["time"]) ? microtime(true)-$a["time"] : 0;
            }
            if($b["display"] == "<ready>" || $b["display"] == "<done>" || $b["display"] == "<init>") {
                $bt=-1;
            } else {
                $bt = isset($b["time"]) ? microtime(true)-$b["time"] : 0;
            }
            if ($at==$bt) return 0;
            return ($at<$bt)?1:-1;
        });
    }

    public function update($done,$active=0,$queued=0,$expected=0) {
        if(is_null($this->timeStarted)) {
            $this->statusBar->start();
            $this->timeStarted = microtime(true);
        }
        if($expected==0) {
            $expected = $done+$queued+$active;
        }
        $this->total = $expected;
        $this->remaining = $this->total - $done;
        if($done>0) {
            $this->percent = ($done / $this->total) * 100;
        } else {
            $this->percent = 0;
        }
        $this->updateBar();
    }
    public function stop() {
        $this->statusBar->stop();
    }
    public function draw() {
        $this->statusBar->draw();
    }

    private function updateBar() {
        $this->bar->set("percent",      number_format($this->percent,2));
        $this->bar->set("remaining",    $this->remaining);
        $this->bar->set("total",        $this->total);
        $this->bar->set("threadData",   $this->threadData);
    }


    public function updateInterval($updateInterval) {
        $this->statusBar->updateInterval($updateInterval);
        return $this;
    }

    public function showExec($showExec) {
        $this->statusBar->showExec($showExec);
        return $this;
    }
    public function showMem($showExec) {
        $this->statusBar->showMem($showExec);
        return $this;
    }

    public function setBarFormat($barFormat) {
        $this->barFormat = $barFormat;
        $this->bar->barFormat($this->barFormat);
    }
    public function setThreads($threads) {
        $this->threadData = array_fill(0,$threads,["time"=>null,"display"=>"<init>"]);
        $this->bar->set("threadDataTemplate","[{time|since|timeFormat} {display|max:10|pad:10}]");
        if(!$this->threadsAdded) {
            $this->barFormat .= " {threadData}";
            $this->threadsAdded=true;
            $this->bar->barFormat($this->barFormat);
        }
    }
}