<?php
namespace boru\dhutils\tools;

use boru\dhutils\dhGlobal;

class DebugTrace {
    private $label = "";
    private $details = [];

    public function __construct($label,...$details) {
        $this->label = $label;
        $this->details = is_null($details) ? [] : $details;
        if(dhGlobal::get("debugTrace",false)) {
            dhGlobal::outLine("DEBUGTRACE","   ",". . . . ",$this->label,...$this->details);
        }
    }

    public static function enable() {
        dhGlobal::set("debugTrace",true);
    }
    public static function disable() {
        dhGlobal::set("debugTrace",false);
    }
    public static function traceSteps($num) {
        dhGlobal::set("debugTraceSteps",$num);
    }
    public static function create($label=null) {
        $traceInfo = static::getTraceInfo(dhGlobal::get("debugTraceSteps",2));
        $notes = "called @ ".$traceInfo["caller"]["line"].":".$traceInfo["caller"]["file"];
        $parts = [];
        $parts[] = " -> ".dhGlobal::padRight($traceInfo["item"]["func"]."()",50);
        $parts[] = " @ ".dhGlobal::padLeft($traceInfo["item"]["line"],4," ");
        $parts[] = " in ".$traceInfo["item"]["file"];
        $parts[] = " ".$notes;
        $label = is_null($label) ? "exectimer" : $label;
        $label = dhGlobal::padRight($label,20);
        return new static($label,...$parts);
    }
    
    public static function getTraceInfo($stepsToDiscard=2,$full=false) {
        $trace = debug_backtrace();
        while($stepsToDiscard-- > 0) {
            array_shift($trace);
        }
        $output = [];
        if(!$full) {
            $output["item"] = static::getTraceEntry(array_shift($trace));
            $output["caller"] = static::getTraceEntry(array_shift($trace));
        } else {
            foreach($trace as $traceEntry) {
                $output[] = static::getTraceEntry($traceEntry);
            }
        }
        return $output;
    }
    private static function getTraceEntry($traceEntry) {
        $trace = [
            "file"=>$traceEntry['file'],
            "line"=>$traceEntry['line'],
            "func"=>$traceEntry['function'],
            "args"=>$traceEntry['args'],
        ];
        //if the trace has a classname, append it to the function name
        if(isset($traceEntry['class'])) {
            $trace["func"] = $traceEntry['class'] . "::" . $traceEntry['function'];
        }
        return $trace;
    }
}