<?php
namespace boru\dhutils\tools;

use boru\dhutils\dhGlobal;

class ExecTimer {

    private $label = "";
    private $details = [];

    private $timeStart;
    private $timeEnd;
    private $shouldOutput = false;
    public function __construct($label,...$details) {
        $this->timeStart = microtime(true);
        $this->label = $label;
        $this->details = is_null($details) ? [] : $details;
    }
    public function __destruct() {
        $this->timeEnd = microtime(true);
        if(dhGlobal::get("execTimer",false)) {
            $timeElapsed = $this->timeEnd - $this->timeStart;
            $timeElapsed = dhGlobal::padLeft(number_format($timeElapsed,4),8," ")."s";
            dhGlobal::outLine("DEBUGTIME","  ",$timeElapsed." ",$this->label,...$this->details);
        }
    }

    public static function enable() {
        dhGlobal::set("execTimer",true);
    }
    public static function disable() {
        dhGlobal::set("execTimer",false);
    }
    public static function traceSteps($num) {
        dhGlobal::set("execTimerSteps",$num);
    }
    public static function create($label=null) {
        $traceInfo = static::getTraceInfo(dhGlobal::get("execTimerSteps",2));
        $notes = "called @ ".$traceInfo["caller"]["line"].":".$traceInfo["caller"]["file"];
        $parts = [];
        $parts[] = " -> ".dhGlobal::padRight($traceInfo["item"]["func"]."()",50);
        $parts[] = " @ ".dhGlobal::padLeft($traceInfo["item"]["line"],4," ");
        $parts[] = " in ".$traceInfo["item"]["file"];
        $parts[] = " ".$notes;
        $label = is_null($label) ? "exectimer" : $label;
        $label = dhGlobal::padRight($label,20);
        return new static($label,...$parts);
    }

    private static function getTraceInfo($stepsToDiscard=2) {
        $trace = debug_backtrace();
        while($stepsToDiscard-- > 0) {
            array_shift($trace);
        }
        $output["item"] = static::getTraceEntry(array_shift($trace));
        $output["caller"] = static::getTraceEntry(array_shift($trace));
        return $output;
    }
    private static function getTraceEntry($traceEntry) {
        $trace = [
            "file"=>$traceEntry['file'],
            "line"=>$traceEntry['line'],
            "func"=>$traceEntry['function'],
            "args"=>$traceEntry['args'],
        ];
        //if the trace has a classname, append it to the function name
        if(isset($traceEntry['class'])) {
            $trace["func"] = $traceEntry['class'] . "::" . $traceEntry['function'];
        }
        return $trace;
    }
}