<?php
namespace boru\dhutils\tools;

use boru\dhutils\dhGlobal;
use boru\dhutils\loader\TypeClass;

class Loader {
    static $loaders = [];
    protected static $baseDir = "";
    protected static $classPrefix = "";
    protected static $includeCache = [];

    public static function init($options=[]) {
        $loader = dhGlobal::getVal($options,"loader",null);
        if(is_null($loader)) {
            $typeClass = new TypeClass();
            $typeClass->classPrefix(static::$classPrefix);
        }
        if($loader !== false) {
            static::addLoader($loader);
        }
    }
    public static function addLoader($loader) {
        if(!is_object($loader)) {
            $class = "\\boru\\dhutils\\loader\\".$loader;
            if(class_exists($class,true)) {
                $loader = new $class;
            }
        }
        $loader->init();
        static::$loaders[] = $loader;
    }

    /**
     * Set the baseDir restriction for the dhLoader::includeOnce method
     * 
     * dhLoader::includeOnce is utilized for the TypeClass loader, and is public static
     * @param mixed $baseDir 
     * @return string|void 
     */
    public static function baseDir($baseDir=null) {
        if(is_null($baseDir)) {
            return static::$baseDir;
        } else {
            static::$baseDir = dhGlobal::trimString(DIRECTORY_SEPARATOR,$baseDir,dhGlobal::TRIM_END);
        }
    }
    /**
     * Wrapper for the TypeClass loader
     * @param string|null $prefix 
     * @return string|void 
     */
    public static function classPrefix(string $prefix=null)
    {
        if(is_null($prefix)) {
            return static::$classPrefix;
        } else {
            static::$classPrefix = $prefix;
        }
    }
    public static function includeOnce($qualifiedName, $fileExtension="php",$supress=false) {
        if(isset(static::$includeCache[$qualifiedName])) {
            return true;
        }
        $file = static::resolveNameToPath($qualifiedName,$fileExtension);
        //dhGlobal::debug("file",$file);
		if (!file_exists($file)) {
            dhGlobal::error("File Doesnt Exist - dhLoader - Error when trying to include $file");
			return false;
		}

        $status = -1;
        if ($supress) {
            $status = @include_once $file;
        } else {
            $status = include_once $file;
        }
        

		$success = ($status === 0)? false : true;

		if ($success) {
			static::$includeCache[$qualifiedName] = $file;
		}
        return $success;
    }
    public static function resolveNameToPath($qualifiedName, $fileExtension='php') {
		$allowedExtensions = array('php', 'js', 'css', 'less');

		$file = '';
		if(!in_array($fileExtension, $allowedExtensions)) {
			return '';
		}
        $baseDir = static::baseDir();
        if(empty($baseDir)) {
            $LOADER_FILE_DIR = "";
        } else {
            $LOADER_FILE_DIR = $baseDir . DIRECTORY_SEPARATOR;
        }
		// TO handle loading vtiger files
		if (strpos($qualifiedName, '~~') === 0) {
			$file = str_replace('~~', '', $qualifiedName);
            $file = $LOADER_FILE_DIR . $file;
		} else if (strpos($qualifiedName, '~') === 0) {
			$file = str_replace('~', '', $qualifiedName);
			$file = $LOADER_FILE_DIR . $file;
		} else {
			$file = str_replace('.', DIRECTORY_SEPARATOR, $qualifiedName) . '.' .$fileExtension;
			$file = $LOADER_FILE_DIR . $file;
		}
		return $file;
	}
}