<?php
namespace boru\dhutils\traits;

use \boru\dhutils\dhGlobal;

trait CommandRun {
    protected $commandResult;
    public function commandRun($result) {
        $this->commandResult = $result;
        $cmdName = $result["commandName"];
        if(method_exists($this,"cmd_".$cmdName)) {
            $cmd = "cmd_".$cmdName;
            $this->$cmd($result);
            return true;
        } elseif(method_exists($this,"cmd_default")) {
            $cmd = "cmd_default";
            $this->$cmd($result);
            return true;
        }
        return false;
    }
    public function getCommandOption($dotKey,$default=false) {
        return dhGlobal::getVal($this->commandResult["options"],$dotKey,$default);
    }
}